import sys

def createServer(nodeName, serverName, serverType):
    template = server.template
        if parameters.template != '':
            template = parameters.template
    args = ['-name', serverName]
    if template is not None and template != '':
        args.append('-templateName')
        args.append(template)
    args = listToAdminTaskArgs(args)
    print "Creating server '%s' on node '%s': %s" % (serverName, nodeName, args)
    if serverType == "APPLICATION_SERVER":
        AdminTask.createApplicationServer(nodeName, args)
    elif serverType == "PROXY_SERVER":
        AdminTask.createProxyServer(nodeName, args)
    else:
        print "Server type '%s' is not supported. Please select the desired server type under in your server properties."
        sys.exit(1)


def checkIfServerExists(nodeName, serverName):
    serverId = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    if serverId != "":
        print "WARN: Server '%s' already exists on node '%s'. Doing nothing." % (serverName, nodeName)
        sys.exit(0)

try:
    server = container

except NameError:
    server = deployed

# ilx: do not create server if it should be part of a cluster?
checkIfServerExists(server.nodeName, server.name)
createServer(server.nodeName, server.name, server.serverType)

saveConfiguration()
syncNode(server.nodeName)

