$shareName = if($deployed.shareName) { $deployed.shareName } else { $deployed.name }

$share = Get-WmiObject -Class Win32_Share -Filter ("Name='$shareName'")
if(!$share) {
    Write-Host "Cannot find share [$shareName] to delete it"
    Exit 1
}

Write-Host "Deleting share [$shareName]"
$res = $share.Delete()

if ($res.ReturnValue -ne 0) {
    Write-Host "Cannot delete share [$shareName] (error code $($res.ReturnValue))"
    exit $res.ReturnValue
}
