$serviceName = if($deployed.serviceName) { $deployed.serviceName } else { $deployed.name }

$service = Get-WmiObject Win32_Service -Filter ("name='$serviceName'")
if(!$service) {
    Write-Output "Cannot uninstall service [$serviceName] because it cannot be found."
    Exit 1
}

Write-Output "Uninstalling service [$serviceName]"
$service.Delete() | Out-Null


