$serviceName = if($deployed.serviceName) { $deployed.serviceName } else { $deployed.name }

function Stop-Service-With-Timeout($serviceName, $timeout) {

    $scriptBlock = {
        param($serviceName)
        Stop-Service -Name $serviceName -Force -ErrorAction SilentlyContinue -WarningAction SilentlyContinue
    }

    $job = Start-Job -ScriptBlock $scriptBlock -ArgumentList $ServiceName
    Wait-Job -Job $job -Timeout $timeout | Out-Null

    if ((Get-Service -Name $ServiceName).Status -ne "Stopped") {
        Write-Output "Cannot stop service [$ServiceName]. Please check the Services control panel and the Event Viewer."
        Exit 1
    }

    # Wait for file handles to be released
    Start-Sleep -Seconds 1
}

Write-Output "Stopping service [$serviceName]."
Stop-Service-With-Timeout $serviceName $deployed.stopTimeout
