function inspectService($service) {
    $id = $container.id + "/" + $service.name
    discovered $id $prototype.type
    inspectedProperty $id "serviceName" $service.name
    inspectedProperty $id "serviceDisplayName" $service.displayName
    inspectedProperty $id "serviceDescription" $service.description
    inspectedProperty $id "binaryPathName" $service.pathName

    $dependsOn = get-service $service.name | select -expandProperty servicesDependedOn | select -expandProperty serviceName
    inspectedProperty $id "dependsOn" "${dependsOn}"

    $startMode = $service.startMode
    if($startMode -eq "Auto") { $startMode = "Automatic" }

    inspectedProperty $id "startupType" $startMode
    inspectedProperty $id "username" $service.startName
    inspectedItem $id
}

$services = Get-WmiObject -Class Win32_Service
if($services) {
    foreach($service in $services) {
        inspectService($service)
    }
}
