$serviceName = if($deployed.serviceName) { $deployed.serviceName } else { $deployed.name }

$service = Get-WmiObject Win32_Service -Filter ("name='$serviceName'")
if(!$service) {
    Write-Host "Cannot uninstall service [$serviceName] because it cannot be found."
    Exit 1
}

Write-Host "Uninstalling service [$serviceName]"
$service.Delete() | Out-Null


