/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wlp.container;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wlp.container.WlpContainer;

@Metadata(description="An standalone WebSphere Liberty Profile server", inspectable=true)
public class Server
extends BaseContainer
implements WlpContainer {
    @Property(asContainment=true, description="Host upon which the container resides")
    private Host host;
    @Property(label="Root installation directory", description="The base directory for the WebSphere Liberty Profile installation, such as /opt/IBM/WebSphereLiberty/.")
    private String wlpInstallDir;
    @Property(required=false, label="Server configuration directory", description="The configuration directory of the WebSphere Liberty Profile server, such as /opt/IBM/WebSphereLiberty/usr/servers/defaultServer. Defaults to ${deployed.wlpInstallDir}/usr/servers/${deployed.name} if not specified.")
    private String serverConfigDir;
    @Property(required=false, label="Reload server configuration", defaultValue="true", category="Reloading", description="Notify the WLP server about server.xml changes after deployments and undeployments.")
    private boolean reloadServerConfiguration;
    @Property(required=false, category="Connector", description="Host name or IP address of the server.")
    private String hostname;
    @Property(required=false, label="HTTPS port", category="Connector", description="HTTPS port of the server where the REST JMX connector is exposed.")
    @Range(minimum=0, maximum=65535, message="Value should be in the range 0 through 65535.")
    private Integer httpsPort;
    @Property(required=false, category="Connector", description="Name of the user to authenticate agains the REST JMX connector.")
    private String username;
    @Property(required=false, password=true, category="Connector", description="Password of the user.")
    private String password;
    @Property(required=false, label="Trust store file path", category="Connector", description="The trust store file containing authorized certificates.")
    private String trustStorePath;
    @Property(required=false, label="Trust store password", password=true, category="Connector", description="The password for the trust store file.")
    private String trustStorePassword;
    @Property(required=false, hidden=true, defaultValue="SSL", category="Connector", description="The underlying protocol used for communication, e.g. SSL, SSLv3, TLS, TLSv1.2 etc.")
    private String sslProtocol;
    @Property(required=false, hidden=true, defaultValue="false", category="Connector", description="Ignores host verification checks, use in development environments only.")
    private boolean trustAllHostnames;
    @Property(required=false, hidden=true, defaultValue="false", category="Connector", description="Ignores certificate verification checks, use in development environments only.")
    private boolean trustAllCertificates;
    @Property(required=false, hidden=true, defaultValue="60000", category="Connector", description="Timeout opening a communications link to the resource, in milliseconds.")
    private Integer connectTimeout;
    @Property(required=false, hidden=true, defaultValue="60000", category="Connector", description="Timeout reading from Input stream when a connection is established, in milliseconds.")
    private Integer readTimeout;

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }
}

