/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="Base deployed of all WLS deployeds.")
public class BaseWlsDeployed<D extends Deployable, C extends PythonManagedContainer>
extends PythonManagedDeployed<D, C> {
    public static final String STEP_OPTION_NONE = "none";
    public static final String STEP_OPTION_UPLOAD_ARTIFACT_DATA = "uploadArtifactData";
    public static final String STEP_OPTION_EXPOSE_DEPLOYED_APPLICATION = "exposeDeployedApplication";
    public static final String STEP_OPTION_EXPOSE_PREVIOUS_DEPLOYED = "exposePreviousDeployed";
    public static final String STEP_OPTIONS_REGEX = "(none|uploadArtifactData|exposeDeployedApplication|exposePreviousDeployed)";
    public static final String STEP_OPTIONS_DESCRIPTION_SUFFIX = " (1 or more of: none,uploadArtifactData,exposeDeployedApplication,exposePreviousDeployed).";
    public static final String STEP_OPTIONS_DEFAULT = "uploadArtifactData";
    @Property(hidden=true, defaultValue="uploadArtifactData", description="Options for the create step (1 or more of: none,uploadArtifactData,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|exposeDeployedApplication|exposePreviousDeployed)")
    protected Set<String> createOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData", description="Options for the modify step (1 or more of: none,uploadArtifactData,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|exposeDeployedApplication|exposePreviousDeployed)")
    protected Set<String> modifyOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData", description="Options for the destroy step (1 or more of: none,uploadArtifactData,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|exposeDeployedApplication|exposePreviousDeployed)")
    protected Set<String> destroyOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData", description="Options for the noop step (1 or more of: none,uploadArtifactData,exposeDeployedApplication,exposePreviousDeployed).")
    @Regex(pattern="(none|uploadArtifactData|exposeDeployedApplication|exposePreviousDeployed)")
    protected Set<String> noopOptions;

    public boolean addStep(DeploymentPlanningContext ctx, Delta delta, int order, String scriptPath, String verb, Set<String> options) {
        return this.addStep(ctx, delta, null, order, scriptPath, verb, options);
    }

    public boolean addStepWithCheckpoint(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        Preconditions.checkNotNull((Object)operation, (Object)"operation is null");
        return this.addStep(ctx, delta, operation, order, scriptPath, verb, options);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        if (!Strings.isNullOrEmpty((String)scriptPath)) {
            PythonDeploymentStep step = this.createStep(ctx, delta, order, scriptPath, verb, options);
            if (operation == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, delta, operation);
            }
            return true;
        }
        return false;
    }

    protected PythonDeploymentStep createStep(DeploymentPlanningContext ctx, Delta delta, int order, String scriptPath, String verb, Set<String> options) {
        Map<String, Object> pythonVars = this.getPythonVars(delta.getPrevious(), ctx.getDeployedApplication(), options);
        PythonDeploymentStep step = new PythonDeploymentStep(order, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), scriptPath, pythonVars, this.getDescription(verb));
        step.setUploadArtifactData(options.contains("uploadArtifactData"));
        return step;
    }

    protected Map<String, Object> getPythonVars(Deployed<?, ?> previous, DeployedApplication deployedApplication, Set<String> options) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", this);
        if (options.contains(STEP_OPTION_EXPOSE_PREVIOUS_DEPLOYED)) {
            Preconditions.checkNotNull(previous, (Object)"previousDeployed is null");
            pythonVars.put("previousDeployed", previous);
        }
        if (options.contains(STEP_OPTION_EXPOSE_DEPLOYED_APPLICATION) || this.getExposeDeployedApplication()) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            pythonVars.put("deployedApplication", deployedApplication);
        }
        return pythonVars;
    }
}

