<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
echo "Stopping ${container.name}...."
RESPONSE_FILE=${container.name}.$$
<#if container.name = container.domain.adminServerName>
echo "stop AdminServer..."
nohup ${container.domain.domainHome}/bin/${container.stopCommand}.sh >> $RESPONSE_FILE 2>&1 &
<#else>
echo "stop ManagedServer..."
nohup ${container.domain.domainHome}/bin/${container.stopCommand}.sh ${container.name}  >> $RESPONSE_FILE 2>&1 &
</#if>

echo "$RESPONSE_FILE"

<#if container.testServerIsRunning >
START_DELAY_SECS=${container.startDelay}

if [ $START_DELAY_SECS -ne 0 ]; then
  echo Waiting $START_DELAY_SECS seconds
  sleep $START_DELAY_SECS
fi

cat $RESPONSE_FILE

MAX_RETRIES=${container.maxRetries}
RETRY_INTERVAL_SECS=${container.retryWaitInterval}

wlstPath="${container.domain.wlHome}/common/bin/wlst.sh"
outputFile=output.$$


i=1
shutdown=1
while [ "$i" -le $MAX_RETRIES ]; do
    echo "--Checking Server Status --"
    (echo "connect('${container.domain.username}', '${container.domain.password}', 't3://${container.domain.hostname}:${container.domain.port}')" ; echo "state('${container.name}', 'Server')"; ) |sh $wlstPath > $outputFile
    sed "s/${container.domain.password}/*****/" $outputFile

    if grep "RUNNING" $outputFile
    then
        echo ERROR: '${container.name}' is still running !
    elif grep "SHUTDOWN" $outputFile
    then
        echo "${container.name} is shutdown."
        shutdown=0
        break
    elif grep "You will need to be connected to a running server to execute this command" $outputFile
    then
        echo "Admin server is shutdown."
        shutdown=0
        break
    else
        echo "WARM: Unable to determine server status. Verify manually"
        shutdown=0
        break
    fi

	i=`expr $i + 1`
	if "$i" -le $MAX_RETRIES
	then
		echo "retry in ${container.retryWaitInterval} seconds"
        sleep $RETRY_INTERVAL_SECS
	fi
done

exit $shutdown

</#if>
