/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WaitingStep;
import java.util.HashSet;
import java.util.Set;

public class ArtifactDeploymentContributor {
    private static final String UPLOAD_ARTIFACT_STEPS = "uploadArtifactSteps";
    private static final String WAITING_STEP_INTERVAL = "waitingStepInterval";
    private static final String DELETE_ARTIFACT_STEPS = "deleteArtifactStep";

    @Contributor
    public static void contributeArtifactUploadStepForNoStage(Deltas deltas, DeploymentPlanningContext ctx) {
        for (UploadArtifactStep uploadStep : ArtifactDeploymentContributor.getUploadArtifactSteps(ctx)) {
            ctx.addStep((Step)uploadStep);
        }
    }

    @Contributor
    public static void contributeArtifactDeleteStepForNoStage(Deltas deltas, DeploymentPlanningContext ctx) {
        for (DeleteArtifactStep deleteArtifactStep : ArtifactDeploymentContributor.getDeleteArtifactSteps(ctx)) {
            ctx.addStep((Step)deleteArtifactStep);
        }
    }

    @Contributor
    public static void contributeWaitStepForSideBySideDeploymentStrategy(Deltas deltas, DeploymentPlanningContext ctx) {
        if (ctx.getAttribute(WAITING_STEP_INTERVAL) != null) {
            ctx.addStep((Step)new WaitingStep(94, (Long)ctx.getAttribute(WAITING_STEP_INTERVAL)));
        }
    }

    public static void addUploadArtifactStep(DeploymentPlanningContext ctx, UploadArtifactStep step) {
        ArtifactDeploymentContributor.getUploadArtifactSteps(ctx).add(step);
    }

    public static void addDeleteArtifactStep(DeploymentPlanningContext ctx, DeleteArtifactStep step) {
        ArtifactDeploymentContributor.getDeleteArtifactSteps(ctx).add(step);
    }

    public static void setWaitStepInterval(DeploymentPlanningContext ctx, long newWaitTime) {
        if (ctx.getAttribute(WAITING_STEP_INTERVAL) != null) {
            long waitTimeInSec = (Long)ctx.getAttribute(WAITING_STEP_INTERVAL);
            if (newWaitTime > waitTimeInSec) {
                ctx.setAttribute(WAITING_STEP_INTERVAL, (Object)newWaitTime);
            }
        } else {
            ctx.setAttribute(WAITING_STEP_INTERVAL, (Object)newWaitTime);
        }
    }

    private static Set<UploadArtifactStep> getUploadArtifactSteps(DeploymentPlanningContext ctx) {
        HashSet steps = (HashSet)ctx.getAttribute(UPLOAD_ARTIFACT_STEPS);
        if (steps == null) {
            steps = new HashSet();
            ctx.setAttribute(UPLOAD_ARTIFACT_STEPS, steps);
        }
        return steps;
    }

    private static Set<DeleteArtifactStep> getDeleteArtifactSteps(DeploymentPlanningContext ctx) {
        HashSet steps = (HashSet)ctx.getAttribute(DELETE_ARTIFACT_STEPS);
        if (steps == null) {
            steps = new HashSet();
            ctx.setAttribute(DELETE_ARTIFACT_STEPS, steps);
        }
        return steps;
    }
}

