/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.CheckWlsClusterMemberNamesStep;
import com.xebialabs.deployit.plugin.wls.step.RetrieveWlsClusterStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDomainCheckReachableStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;

@ConfigurationItem(description="A WebLogic Cluster, a member of WebLogic Domain. It can have WebLogicServers as it's members", category="middleware", discoverable=true)
public class WlsCluster
extends WlsTarget
implements Discoverable<WlsCluster> {
    public static final Transformer TOSTRING_FROM_NAME = new Transformer(){

        public String transform(Object obj) {
            return ((WlsCluster)((Object)obj)).getName();
        }
    };
    @ConfigurationItemProperty(required=true, identifying=true, description="Name of the WebLogic Cluster")
    private String name = "";
    @ConfigurationItemProperty(required=true, asContainment=true, description="The domain to which the WebLogic Cluster belongs")
    private WlsDomain domain;
    @ConfigurationItemProperty(description="Servers in the WebLogic Cluster")
    private Set<WlsServer> servers = new HashSet<WlsServer>();

    @Override
    public String getTargetObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Cluster";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public WlsDomain getDomain() {
        return this.domain;
    }

    public void setDomain(WlsDomain domain) {
        this.domain = domain;
    }

    public Set<WlsServer> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void setServers(Set<WlsServer> servers) {
        this.servers = servers;
    }

    public Host getHost() {
        return this.getDomain().getActiveHost();
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new WlsDomainCheckReachableStep(this.getDomain()));
        steps.add(new RetrieveWlsClusterStep(this));
        HashSet<String> allServerNames = new HashSet<String>();
        for (WlsServer server : this.servers) {
            allServerNames.add(server.getName());
        }
        steps.add(new CheckWlsClusterMemberNamesStep(this, allServerNames));
        return steps;
    }

    public WlsCluster discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(this.getCheckSteps());
        cp.execute(info);
        return this;
    }

    public WlsCluster discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }
}

