/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.RetrieveWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDomainCheckReachableStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

@ConfigurationItem(description="A standard Weblogic Server", discoverable=true)
public class WlsServer
extends WlsTarget
implements Discoverable<WlsServer> {
    @ConfigurationItemProperty(required=true, description="Name of the WebLogic Server", identifying=true)
    private String name;
    @ConfigurationItemProperty(required=true, description="Port for the WebLogic Server")
    private int port;
    @ConfigurationItemProperty(description="Classpath entries for this server.")
    private String classpath;
    @ConfigurationItemProperty(description="The arguments for this server, including initial heapsize (e.g. -Xms64m), maxheap size (-Xms256m), and bootclasspath (-Xbootclasspath/p:/var/lib/addons.jar)", size=ConfigurationItemProperty.Size.LARGE)
    private String arguments;
    @ConfigurationItemProperty(description="Absolute path of log file. Example; /opt/bea/user_projects/domain/managedserver1/ms1.log")
    private String logFileLocation;
    @ConfigurationItemProperty(description="Enable JVM StdOut to Server Log file")
    private boolean enableJVMLogRedirection = false;
    @ConfigurationItemProperty(required=true, asContainment=true, description="WebLogic Domain to which this server belongs")
    private WlsDomain domain;
    @ConfigurationItemProperty(required=true, description="Host on which this server is running")
    private Host host;
    @ConfigurationItemProperty(required=false, label="Managed server start command", description="Command that should be executed to start the managed server.", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String startCommand;
    @ConfigurationItemProperty(required=false, label="Managed server stop command", description="Command that should be executed to stop the managed server.", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String stopCommand;
    @ConfigurationItemProperty(required=false, description="Deployment staging mode (default is stage)")
    private WlsStageMode stageMode = WlsStageMode.Stage;

    public static List<WlsServer> toNameSortedList(Set<WlsServer> servers) {
        ArrayList<WlsServer> nameSortedServers = new ArrayList<WlsServer>(servers);
        Collections.sort(nameSortedServers, new BeanComparator("name"));
        return nameSortedServers;
    }

    @Override
    public String getTargetObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Server";
    }

    @Override
    public WlsDomain getDomain() {
        return this.domain;
    }

    public void setDomain(WlsDomain domain) {
        this.domain = domain;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getLogFileLocation() {
        return this.logFileLocation;
    }

    public void setLogFileLocation(String logFileLocation) {
        this.logFileLocation = logFileLocation;
    }

    public boolean isEnableJVMLogRedirection() {
        return this.enableJVMLogRedirection;
    }

    public void setEnableJVMLogRedirection(boolean enableJVMLogRedirection) {
        this.enableJVMLogRedirection = enableJVMLogRedirection;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.host));
        steps.add(new WlsDomainCheckReachableStep(this.getDomain()));
        steps.add(new RetrieveWlsServerStep(this));
        return steps;
    }

    public WlsServer discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(this.getCheckSteps());
        cp.execute(info);
        return this;
    }

    public WlsServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    public WlsStageMode getStageMode() {
        return this.stageMode == null ? WlsStageMode.Stage : this.stageMode;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }
}

