/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

public abstract class ApacheWlsPluginConfigFileStep
implements Step {
    protected static final String DEFAULT_WL_APACHE_VHOST_TEMPLATE = "com/xebialabs/deployit/plugin/wls/step/apache_wl_conf_template.vm";
    protected ApacheHttpdServer webServer;
    protected ApacheHttpdWlsPluginConfiguration pluginConfiguration;
    protected String virtualHost;
    protected String virtualHostServerName;
    protected String virtualHostPort;
    protected boolean usingVirtualHost;
    protected WlsServer wlServer;
    protected WlsCluster cluster;
    protected String pluginConfigLocation;
    protected String wlConfigFilePath;
    protected String clusterSpecification;
    protected String description;

    protected ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsServer wlServer, String virtualHost) {
        this(webServer, pluginConfiguration, virtualHost);
        this.wlServer = wlServer;
        this.init();
    }

    protected ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsCluster cluster, String virtualHost) {
        this(webServer, pluginConfiguration, virtualHost);
        this.cluster = cluster;
        this.init();
    }

    private ApacheWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, String virtualHost) {
        if (StringUtils.isBlank((String)pluginConfiguration.getMimeMatchExpressions()) && StringUtils.isBlank((String)pluginConfiguration.getPathExpressions())) {
            throw new ResolutionException("Both Mime Match Expression and Path Expression can't be left blank");
        }
        this.pluginConfiguration = pluginConfiguration;
        this.virtualHost = virtualHost;
        this.usingVirtualHost = StringUtils.isNotEmpty((String)virtualHost);
        if (this.usingVirtualHost) {
            if (virtualHost.indexOf(58) > -1) {
                this.virtualHostServerName = virtualHost.substring(0, virtualHost.indexOf(58));
                this.virtualHostPort = virtualHost.substring(virtualHost.indexOf(58) + 1);
            } else {
                throw new ResolutionException("Virtual host property " + virtualHost + ", syntax incorrect, expecting <HOSTNAME:PORT>");
            }
        }
        this.webServer = webServer;
    }

    private void init() {
        assert (this.cluster != null || this.wlServer != null) : "At least a cluster or server is expected";
        if (this.usingVirtualHost) {
            this.wlConfigFilePath = this.webServer.getConfFilePathForVirtualHost(this.virtualHost);
        } else {
            String clusterOrServerName = this.isTargetCluster() ? this.cluster.getName() : this.wlServer.getName();
            this.wlConfigFilePath = this.webServer.getConfigurationLocation() + this.webServer.getHost().getOperatingSystemFamily().getFileSeparator() + "wls_" + clusterOrServerName + ".conf";
        }
        this.pluginConfigLocation = System.getProperty("java.io.tmpdir") + Host.getLocalHost().getFileSeparator() + this.wlConfigFilePath;
        this.clusterSpecification = this.getCommaSeparatedIpPortList(this.cluster.getServers());
    }

    protected String getCommaSeparatedIpPortList(Set<WlsServer> wlServers) {
        return ExtendedStringUtils.join(wlServers, (Transformer)new Transformer(){

            public String transform(Object obj) {
                WlsServer server = (WlsServer)((Object)obj);
                return server.getHost().getAddress() + ":" + server.getPort();
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWlConfigFileName() {
        return this.wlConfigFilePath;
    }

    public String getPluginConfigLocation() {
        return this.pluginConfigLocation;
    }

    private boolean isTargetCluster() {
        return this.cluster != null;
    }
}

