/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.mapper.JmsMapperUtils;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.Set;

public class CreateWlsSubdeploymentStep
extends SimpleWlstExecutingStep {
    private static final String SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/create-subdeployment.py";

    public CreateWlsSubdeploymentStep(WlsDomain domain, String jmsModuleName, WlsJmsServer jmsServer) {
        this(domain, jmsModuleName, Sets.newHashSet((Object[])new WlsJmsServer[]{jmsServer}));
    }

    public CreateWlsSubdeploymentStep(WlsDomain domain, String jmsModuleName, Set<WlsJmsServer> jmsServers) {
        super("Create Subdeployment " + JmsMapperUtils.getSubdeploymentName(jmsModuleName, jmsServers) + " in module " + jmsModuleName + " targeted at JMS servers " + jmsServers + " on domain " + (Object)((Object)domain), domain, SCRIPT_RESOURCE_PATH, CreateWlsSubdeploymentStep.getArgs(jmsModuleName, jmsServers));
    }

    private static String[] getArgs(String jmsModuleName, Set<WlsJmsServer> jmsServers) {
        ArrayList args = Lists.newArrayList();
        args.add(JmsMapperUtils.getSubdeploymentName(jmsModuleName, jmsServers));
        args.add(jmsModuleName);
        for (WlsJmsServer jmsServer : jmsServers) {
            args.add(jmsServer.getName());
        }
        return args.toArray(new String[args.size()]);
    }
}

