/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.SimpleWlstExecutingStep;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ModifyWlsServerStep
extends SimpleWlstExecutingStep {
    private static final String CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/wls/step/configure-server.py";

    public ModifyWlsServerStep(WlsServer server) {
        super("Modify Server " + server.getHost() + " in domain " + (Object)((Object)server.getDomain()) + " on host " + server.getHost(), server.getDomain(), CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH, ModifyWlsServerStep.getArgs(server));
    }

    private static String[] getArgs(WlsServer server) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(server.getName());
        args.add(server.getDomain().getWlHome());
        ModifyWlsServerStep.addConfigureServerArgument("arguments", server.getArguments(), args);
        ModifyWlsServerStep.addConfigureServerArgument("classpath", server.getClasspath(), args);
        ModifyWlsServerStep.addConfigureServerArgument("logfilename", server.getLogFileLocation(), args);
        ModifyWlsServerStep.addConfigureServerArgument("redirectstdouttoserverlog", String.valueOf(server.isEnableJVMLogRedirection()), args);
        ModifyWlsServerStep.addConfigureServerArgument("listenport", server.getPort(), args);
        return args.toArray(new String[args.size()]);
    }

    private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
        if (StringUtils.isNotBlank((String)propvalue)) {
            args.add(propname);
            args.add(propvalue);
        }
    }

    private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
        if (propvalue != 0) {
            args.add(propname);
            args.add(Integer.toString(propvalue));
        }
    }
}

