/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import java.util.Map;

public class RetrieveWlsDomainStep
implements Step {
    private WlsDomain domain;

    public RetrieveWlsDomainStep(WlsDomain domain) {
        this.domain = domain;
    }

    public boolean execute(StepExecutionContext ctx) {
        ctx.logOutput(this.getDescription());
        String containmentpath = "/";
        Map<String, String> objectOnfo = this.domain.getObjectInfo(containmentpath);
        if (objectOnfo == null) {
            ctx.logError("Cannot retrieve information from WebLogic domain. Please check the logs");
            return false;
        }
        this.domain.setName(objectOnfo.get("Name"));
        this.domain.setAdminServerName(objectOnfo.get("AdminServerName"));
        this.domain.setDomainHome(objectOnfo.get("RootDirectory"));
        return true;
    }

    public String getDescription() {
        return "Retrieve properties of WebLogic domain \"" + this.domain.getLabel() + " such as name, admin server name and domain home";
    }
}

