/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import static com.google.common.collect.Sets.newHashSet;

import java.util.Set;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wls.ci.WlsClusterResource;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;

/**
 * A JMS queue defined in a WLS {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A WebLogic JMS Queue")
public class WlsJmsDistributedQueue extends BaseConfigurationItem implements WlsClusterResource {
	
	public enum LoadBalancingPolicy {
		ROUND_ROBIN("Round-Robin"), RANDOM("Random");

		private final String value;
		
		private LoadBalancingPolicy(String value) {
			this.value = value;
		}
		
		public String getValue() {
			return value;
		}
	}
	
	@ConfigurationItemProperty(description = "The name of the distributed queue", required = true, identifying = true)
	private String name;

	@ConfigurationItemProperty(required = true)
	private String jndiName;
	
	@ConfigurationItemProperty
	private LoadBalancingPolicy loadBalancingPolicy;
	
	@ConfigurationItemProperty(description = "Defaults to -1")
	private int forwardDelay = -1;
	
	@ConfigurationItemProperty
	private Set<WlsJmsQueue> members = newHashSet();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public LoadBalancingPolicy getLoadBalancingPolicy() {
		return loadBalancingPolicy;
	}

	public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
		this.loadBalancingPolicy = loadBalancingPolicy;
	}

	public int getForwardDelay() {
		return forwardDelay;
	}

	public void setForwardDelay(int forwardDelay) {
		this.forwardDelay = forwardDelay;
	}

	public Set<WlsJmsQueue> getMembers() {
		return members;
	}
	
	public void addMember(WlsJmsQueue member) {
		members.add(member);
	}

	public void setMembers(Set<WlsJmsQueue> members) {
		this.members = members;
	}
}
