package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerConfigurationModification;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.step.ApplyWlsServerConfigurationModificationStep;

public class WlsServerConfigurationModificationToWlsServerMapper extends
        ModificationSupportingMappingAgnosticStepGeneratingMapper<WlsServerConfigurationModification, WlsServerResourceMapping, WlsServer> {

	public WlsServerConfigurationModificationToWlsServerMapper(Change<Deployment> change) {
		super(change, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsServerConfigurationModification mod, WlsServer server, List<Step> steps) {
		steps.add(new ApplyWlsServerConfigurationModificationStep(server, mod, null));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsServerConfigurationModification mod, WlsServer server, List<Step> steps) {
		steps.add(new ApplyWlsServerConfigurationModificationStep(server, null, mod));
	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WlsServerConfigurationModification oldMod, WlsServer oldServer,
	        WlsServerConfigurationModification newMod, WlsServer newServer, List<Step> steps) {
		steps.add(new ApplyWlsServerConfigurationModificationStep(newServer, newMod, oldMod));
	}

}
