/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.plugin.wls.ci.*;
import org.apache.commons.lang.StringUtils;

/**
 * Creates a {@link WlsDataSource JDBC DataSource}.
 */
@SuppressWarnings("serial")
public class CreateWlsDataSourceStep extends SimpleWlstExecutingStep {

    public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";

    public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on cluster " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(
                cluster.getTargetObjectName(), wlsDataSource));
    }

    public CreateWlsDataSourceStep(WlsServer server, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on server " + server, server.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(server.getTargetObjectName(),
                wlsDataSource));
    }

    public CreateWlsDataSourceStep(WlsDomain domain, Set<WlsTarget> targets, WlsDataSource wlsDataSource) {
        super("Create datasource " + wlsDataSource + " on domain " + domain + " targeted to " + targets, domain, SCRIPT_RESOURCE_PATH, getArgs(concatTargets(targets), wlsDataSource));
    }

    private static String concatTargets(Set<WlsTarget> targets) {
        return StringUtils.join(Collections2.transform(targets, new Function<WlsTarget, String>() {
            public String apply(WlsTarget from) {
                return from.getTargetObjectName();
            }
        }), ";");
    }


    private static List<CmdLineArgument> getArgs(String targetObjectName, WlsDataSource webLogicDatasource) {
        List<CmdLineArgument> args = new ArrayList<CmdLineArgument>();
        args.add(CmdLineArgument.arg(targetObjectName));
        args.add(CmdLineArgument.arg(webLogicDatasource.getName()));
        args.add(CmdLineArgument.arg(webLogicDatasource.getJndiName()));
        args.add(CmdLineArgument.arg(webLogicDatasource.getUri()));
        if (StringUtils.isBlank(webLogicDatasource.getUserName())) {
            args.add(CmdLineArgument.arg(""));
        } else {
            args.add(CmdLineArgument.arg(webLogicDatasource.getUserName()));
        }
        if (StringUtils.isBlank(webLogicDatasource.getPassword())) {
            args.add(CmdLineArgument.arg(""));
        } else {
            args.add(CmdLineArgument.password(webLogicDatasource.getPassword()));
        }
        args.add(CmdLineArgument.arg(webLogicDatasource.getDriver()));
        args.add(CmdLineArgument.arg(String.valueOf(webLogicDatasource.getInit())));
        args.add(CmdLineArgument.arg(String.valueOf(webLogicDatasource.getMax())));
        if (webLogicDatasource.getProperties() != null) {
            args.add(CmdLineArgument.arg(webLogicDatasource.getProperties()));
        } else {
            args.add(CmdLineArgument.arg("None"));
        }
        return args;
    }

}
