/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsMailSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

/**
 * Creates a {@link WlsMailSession mail session}.
 */
@SuppressWarnings("serial")
public class CreateWlsMailSessionStep extends SimpleWlstExecutingStep {

	public CreateWlsMailSessionStep(WlsMailSession mailSession,  WlsDomain domain, WlsTarget target) {
		super("Create Mail Session " + mailSession + " in domain " + domain, domain, STEP_RESOURCES_PATH + "create-mail-session.py", getArgs(
				mailSession, domain, target));
	}

	private static List<CmdLineArgument> getArgs(WlsMailSession mailSession, WlsDomain domain, WlsTarget target) {
		List<CmdLineArgument> args = new ArrayList<CmdLineArgument>();
		args.add(CmdLineArgument.arg(mailSession.getName()));
		args.add(CmdLineArgument.arg(domain.getName()));
		args.add(CmdLineArgument.arg(target.getName()));
		args.add(CmdLineArgument.arg(mailSession.getJndiName()));
		
		// urgh! Must be a better way to do this
		for (KeyValuePair javaMailProperty : mailSession.getJavaMailProperties()) {
			args.add(CmdLineArgument.arg(javaMailProperty.getKey()));
			args.add(CmdLineArgument.arg(javaMailProperty.getValue()));
		}
		return args;
	}

}
