/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

import java.util.Map;

/**
 * Deploys applications on a {@link com.xebialabs.deployit.plugin.wls.ci.WlsCluster cluster} V8 or {@link com.xebialabs.deployit.plugin.wls.ci.WlsServer managed server} V8 using nostage mode.
 */
@SuppressWarnings("serial")
public class Wls8DeployNoStageArtifactStep extends Wls8WeblogicDeployerStepBase implements Step {

	private String extension;
	private String targetName;
	private String applicationName;
	private String remoteArchivePath;

	public Wls8DeployNoStageArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, String remoteArchivePath) {
		super(target.getDomain());
		this.targetName = target.getName();
		this.applicationName = artifact.getName();
		this.extension = findOutExtension(artifact);
		this.remoteArchivePath = remoteArchivePath;
		setDescription("Deploy  " + artifact + " on " + target + " nostage mode using " + remoteArchivePath);
	}


	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {
			Map<String, String> velocityContext = Maps.newHashMap();
			velocityContext.put("username", domain.getUsername());
			velocityContext.put("password", domain.getPassword());
			velocityContext.put("adminurl", domain.getConnectUrl());
			velocityContext.put("wlHome", domain.getWlHome());
			velocityContext.put("uploadedApplication", remoteArchivePath);
			velocityContext.put("target", targetName);
			velocityContext.put("name", applicationName);
			velocityContext.put("deployerAction", "-upload -nostage  -deploy " + remoteArchivePath);

			return executeWeblogicDeployerScript(ctx, rhs, velocityContext) == 0;
		} finally {
			rhs.close();
		}
	}
}
