/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.mapper.JmsMapperUtils;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsJmsQueueStep;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class WlsJmsQueueToWlsServerMapper
extends ModificationSupportingMappingAgnosticStepGeneratingMapper<WlsJmsQueue, WlsServerResourceMapping, WlsServer> {
    private final Map<WlsServer, WlsCluster> oldServerClusters;
    private final Map<WlsServer, WlsCluster> newServerClusters;

    public WlsJmsQueueToWlsServerMapper(Change<Deployment> change, Map<WlsServer, WlsCluster> oldServerClusters, Map<WlsServer, WlsCluster> newServerClusters) {
        super(change, false);
        this.oldServerClusters = oldServerClusters;
        this.newServerClusters = newServerClusters;
    }

    protected void generateAdditionStepsForAddedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            this.checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(queue);
            steps.add(new CreateWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, WlsJmsQueueToWlsServerMapper.getClusterIfApplicable(server, this.newServerClusters)), queue));
        }
    }

    private static WlsTarget getClusterIfApplicable(WlsServer server, Map<WlsServer, WlsCluster> serverClusters) {
        return (WlsTarget)((Object)ObjectUtils.defaultIfNull((Object)((Object)serverClusters.get((Object)server)), (Object)((Object)server)));
    }

    protected void generateModificationStepsForModifiedMapping(WlsJmsQueue oldQueue, WlsServer oldServer, WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            this.checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(queue);
            steps.add(new ModifyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, WlsJmsQueueToWlsServerMapper.getClusterIfApplicable(server, this.newServerClusters)), queue));
        }
    }

    private void checkErrorDestinationSuppliedWhenRedirectExpirationPolicy(WlsJmsQueue queue) {
        if (ObjectUtils.equals((Object)((Object)queue.getExpirationPolicy()), (Object)((Object)WlsJmsQueue.ExpirationPolicy.REDIRECT)) && queue.getErrorQueue() == null) {
            throw new ResolutionException("Can not use 'Redirect' as message expiration policy if error destination is not defined for destination " + queue.getName());
        }
    }

    protected void generateDeletionStepsForDeletedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
        if (server.isRunningVersionGreaterThan9()) {
            steps.add(new DestroyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, WlsJmsQueueToWlsServerMapper.getClusterIfApplicable(server, this.oldServerClusters)), queue, server));
        }
    }
}

