/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class DetectBrokenWlstStep
extends WlsStepBase {
    public DetectBrokenWlstStep(WlsDomain domain) {
        super(domain);
        this.setDescription("Detect broken wlst.sh script");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(StepExecutionContext ctx) {
        block16: {
            block15: {
                boolean bl;
                HostSession s;
                block14: {
                    if (this.domain.getActiveHost().getOperatingSystemFamily() != OperatingSystemFamily.UNIX) {
                        ctx.logOutput((Object)((Object)this.domain) + " does not run on a Unix box. Disabling workaround.");
                        this.domain.setEnableWlstShWorkaround(false);
                        return true;
                    }
                    s = this.domain.connectToAdminHost();
                    try {
                        String wlstPath = this.domain.getWlstPath();
                        ctx.logOutput("Reading " + wlstPath + " from " + (Object)((Object)this.domain) + " to determine whether it is broken.");
                        HostFile wlstSh = s.getFile(wlstPath);
                        BufferedReader wlstReader = new BufferedReader(new InputStreamReader(wlstSh.get()));
                        try {
                            String wlstLine;
                            while ((wlstLine = wlstReader.readLine()) != null) {
                                if (!wlstLine.contains("${JAVA_HOME}/bin/java") || !wlstLine.contains("weblogic.WLST")) continue;
                                boolean containsIncorrectExpansion = wlstLine.contains("$*");
                                if (containsIncorrectExpansion) {
                                    ctx.logOutput("Found broken wlst.sh. Enabling workaround.");
                                } else {
                                    ctx.logOutput("Found correct wlst.sh. Disabling workaround");
                                }
                                this.domain.setEnableWlstShWorkaround(containsIncorrectExpansion);
                                bl = true;
                                break block14;
                            }
                            break block15;
                        }
                        finally {
                            wlstReader.close();
                        }
                    }
                    catch (IOException exc) {
                        ctx.logError("Could not determine whether wlst.sh was broken. Assuming it is correct and disabling workaround.", (Throwable)exc);
                        break block16;
                    }
                    catch (RuntimeIOException rte) {
                        ctx.logError("Could not determine whether wlst.sh was broken. Assuming it is correct and disabling workaround.", (Throwable)rte);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                s.close();
                return bl;
            }
            ctx.logError("Could not determine whether wlst.sh was broken. Assuming it is correct and disabling workaround.");
        }
        this.domain.setEnableWlstShWorkaround(false);
        return true;
    }
}

