/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import org.apache.commons.lang.StringUtils;

public class WlsDeployNoStageArtifactStep
extends WlsStepBase {
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-application.py";
    private String targetName;
    private String applicationName;
    private String remoteArchivePath;
    private String remoteDeploymentPlanPath;
    private boolean libraryModule = false;

    public WlsDeployNoStageArtifactStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, String remoteArchivePath) {
        super(wlsTarget.getDomain());
        this.targetName = wlsTarget.getName();
        this.applicationName = artifact.getName();
        this.remoteArchivePath = remoteArchivePath;
        this.libraryModule = artifact instanceof WlsSharedLibrary;
        this.setDescription("Deploy  " + artifact + " on " + (Object)((Object)wlsTarget) + " nostage mode using " + remoteArchivePath);
    }

    @Override
    public String getDescription() {
        String desc = super.getDescription();
        if (!StringUtils.isBlank((String)this.remoteDeploymentPlanPath)) {
            desc = desc + " and a deployment plan";
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            int res;
            CmdLine cmdLine = new CmdLine();
            cmdLine.addArgument(this.domain.getUsername());
            cmdLine.addPassword(this.domain.getPassword());
            cmdLine.addArgument(this.domain.getConnectUrl());
            cmdLine.addArgument(this.targetName);
            cmdLine.addArgument(this.applicationName);
            cmdLine.addArgument(rhs.getFile(this.remoteArchivePath).getPath().replace('\\', '/'));
            cmdLine.addArgument("stageMode");
            cmdLine.addArgument("nostage");
            cmdLine.addArgument("upload");
            cmdLine.addArgument("false");
            if (this.hasDeploymentPlan()) {
                cmdLine.addArgument(rhs.getFile(this.remoteDeploymentPlanPath).getPath().replace('\\', '/'));
                cmdLine.addArgument("planPath");
                cmdLine.addArgument(this.remoteDeploymentPlanPath);
            }
            if (this.libraryModule) {
                cmdLine.addArgument("libraryModule");
                cmdLine.addArgument("true");
            }
            boolean bl = (res = this.executeWlstJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME, cmdLine)) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    public boolean hasDeploymentPlan() {
        return this.remoteDeploymentPlanPath != null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setRemoteDeploymentPlanPath(String remoteDeploymentPlanPath) {
        this.remoteDeploymentPlanPath = remoteDeploymentPlanPath;
    }

    public void setLibraryModule(boolean libraryModule) {
        this.libraryModule = libraryModule;
    }

    public boolean isLibraryModule() {
        return this.libraryModule;
    }
}

