/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class WlsStepBase
implements Step {
    public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/wls/step/";
    protected String description;
    protected WlsDomain domain;

    protected WlsStepBase(WlsDomain domain) {
        this.domain = domain;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int executeWlstJythonScriptResource(StepExecutionContext ctx, HostSession s, String scriptResourcePath, CmdLine cmdLine) {
        String scriptPath = s.copyToTemporaryFile((Resource)new ClassPathResource(scriptResourcePath)).getPath();
        StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
        return this.domain.executeWlstJythonScript((CommandExecutionCallbackHandler)handler, s, scriptPath, cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeWlstJythonScriptResource(StepExecutionContext ctx, String scriptResourcePath, CmdLine cmdLine) {
        HostSession s = this.domain.connectToAdminHost();
        try {
            int n = this.executeWlstJythonScriptResource(ctx, s, scriptResourcePath, cmdLine);
            return n;
        }
        finally {
            s.close();
        }
    }
}

