package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

@ConfigurationItem(description = "A mapping of a datasource to a WLS domain with specified targets")
public class WlsDatasourceToDomainMapping extends SourcePropertyOverridingMapping<WlsDataSource, WlsDomain> {

    @ConfigurationItemProperty(description = "The targets (WlsCluster, WlsServer), where the datasource is mapped to")
    private Set<WlsTarget> targets = newHashSet();

    public WlsDatasourceToDomainMapping() {
        super();
    }

    public WlsDatasourceToDomainMapping(WlsDataSource source, WlsDomain target) {
        super(source, target);
    }

    public Set<WlsTarget> getTargets() {
        return targets;
    }

    public void setTargets(Set<WlsTarget> targets) {
        this.targets = targets;
    }
}
