/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.*;

/**
 * Creates the configuration for the Apache WebLogic plugin on the basis of a {@link ApacheHttpdWlsPluginConfiguration}.
 */
@SuppressWarnings("serial")
public class CreateApacheHttpdWlsPluginConfigFileStep extends ApacheWlsPluginConfigFileStep {

	public CreateApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsCluster cluster,
			String virtualHost) {
		super(webServer, pluginConfiguration, cluster, virtualHost);
		setDescription("Generate Weblogic Apache Plugin configuration file on " + webServer.getHost());
	}

	public CreateApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsServer server,
			String virtualHost) {
		super(webServer, pluginConfiguration, server, virtualHost);
		setDescription("Generate Weblogic Apache Plugin configuration file on " + webServer.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = webServer.connectToAdminHost();
		try {
			ctx.logOutput("Creating Apache Weblogic configuration file at " + wlConfigFilePath);

			HostFile apacheWlConfFile = hostSession.getFile(wlConfigFilePath);
			String apacheWLConfiguration = resolveUsingVelocity();
			if (logger.isDebugEnabled()) {
				logger.debug("resolved wl config template:" + apacheWLConfiguration);
			}
			apacheWlConfFile.put(IOUtils.toInputStream(apacheWLConfiguration), apacheWLConfiguration.length());
			return true;
		} finally {
			hostSession.close();
		}
	}

	private String resolveUsingVelocity() {
		VelocityEngine ve = new VelocityEngine();
		try {
			ve.init();
		} catch (Exception exc) {
			throw new IllegalStateException("Cannot initialize Velocity templating engine", exc);
		}
		// populate context for velocity use
		Map<String, Object> velocityContext = getVelocityContext();
		VelocityContext vc = new VelocityContext(velocityContext);

		ClassPathResource scriptResource = new ClassPathResource(DEFAULT_WL_APACHE_VHOST_TEMPLATE);
		InputStream scriptIn;
		try {
			scriptIn = scriptResource.getInputStream();
		} catch (IOException exc) {
			throw new IllegalArgumentException("Cannot read script template resource " + DEFAULT_WL_APACHE_VHOST_TEMPLATE, exc);
		}

		String evaluatedScript;
		try {
			StringWriter evaluatedTemplateWriter = new StringWriter();
			ve.evaluate(vc, evaluatedTemplateWriter, " ", new InputStreamReader(scriptIn, "UTF-8"));
			evaluatedScript = evaluatedTemplateWriter.getBuffer().toString();
		} catch (IOException exc) {
			throw new RuntimeException("Cannot evaluate script template resource " + DEFAULT_WL_APACHE_VHOST_TEMPLATE, exc);
		} finally {
			IOUtils.closeQuietly(scriptIn);
		}
		return evaluatedScript;
	}

	private Map<String, Object> getVelocityContext() {
		Map<String, Object> velocityContext = new HashMap<String, Object>();
		velocityContext.put("usingVhost", usingVirtualHost);
		if (usingVirtualHost) {
			velocityContext.put("vhostServerName", virtualHostServerName);
			velocityContext.put("vhostPort", virtualHostPort);
			velocityContext.put("documentroot", webServer.getHtdocsDirPathForVirtualHost(virtualHost));
		}
		velocityContext.put("clusterSpecification", clusterSpecification);
		if (!StringUtils.isBlank(pluginConfiguration.getErrorPage())) {
			velocityContext.put("errorPage", pluginConfiguration.getErrorPage());
		}

		List<String> mimeExpressions = new ArrayList<String>();
		if (!StringUtils.isBlank(pluginConfiguration.getMimeMatchExpressions())) {
			String[] mimeMatchExpressions = StringUtils.split(pluginConfiguration.getMimeMatchExpressions(), ",");
			mimeExpressions.addAll(Arrays.asList(mimeMatchExpressions));
		}
		velocityContext.put("matchExpressions", mimeExpressions);

		List<String> pathExpressions = new ArrayList<String>();
		if (!StringUtils.isBlank(pluginConfiguration.getPathExpressions())) {
			String[] pathExpressionsArr = StringUtils.split(pluginConfiguration.getPathExpressions(), ",");
			pathExpressions.addAll(Arrays.asList(pathExpressionsArr));
		}
		velocityContext.put("locations", pathExpressions);
		return velocityContext;
	}

    private static final Logger logger = LoggerFactory.getLogger(CreateApacheHttpdWlsPluginConfigFileStep.class);
}
