/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;

import static com.xebialabs.deployit.hostsession.CmdLineArgument.arg;
import static java.lang.String.valueOf;

/**
 * Modifies a {@link WlsJmsQueue}.
 */
@SuppressWarnings("serial")
public class ModifyWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "modify-jms-queue.py";

	public ModifyWlsJmsQueueStep(WlsDomain domain, String jmsModuleName, WlsJmsQueue modifiedQueue) {
		super("Modify JMS Queue " + modifiedQueue + " in module " + jmsModuleName + " on domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(domain,
				jmsModuleName, modifiedQueue));
	}

	private static List<CmdLineArgument> getArgs(WlsDomain domain, String jmsModuleName, WlsJmsQueue modifiedQueue) {
		List<CmdLineArgument> args = new ArrayList<CmdLineArgument>();
		args.add(arg(jmsModuleName));
		args.add(arg(modifiedQueue.getJmsServer().getSubdeploymentName(jmsModuleName)));
		args.add(arg(modifiedQueue.getName()));
		args.add(arg(modifiedQueue.getJndiName()));
		args.add(arg(valueOf(modifiedQueue.getRedeliveryDelayOverride())));
		args.add(arg(valueOf(modifiedQueue.getRedeliveryLimits())));
		args.add(arg(modifiedQueue.getExpirationPolicy() != null ? modifiedQueue.getExpirationPolicy().name() : ""));
		args.add(arg(modifiedQueue.getExpirationLoggingFormat()));
		args.add(arg(modifiedQueue.getErrorQueue() != null ? modifiedQueue.getErrorQueue().getName() : ""));
		return args;
	}
}