/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.util.TemplateResolver;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;


public abstract class Wls8WeblogicDeployerStepBase implements Step {


	public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/wls/step/";

	private static final String WEBLOGIC_DEPLOYER_WIN_TEMPLATE = STEP_RESOURCES_PATH + "weblogic_deployer_win.template";
	private static final String WEBLOGIC_DEPLOYER_UNX_TEMPLATE = STEP_RESOURCES_PATH + "weblogic_deployer_unix.template";


	protected String description;
	protected WlsDomain domain;

	public Wls8WeblogicDeployerStepBase(WlsDomain domain) {
		this.domain = domain;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	protected String generateWithVelocity(String templatePath, Map<String, String> context) {
		InputStream scriptIn;
		try {
			scriptIn = new ClassPathResource(templatePath).getInputStream();
		} catch (IOException exc) {
			throw new IllegalArgumentException("Cannot read script template resource " + templatePath, exc);
		}

		try {
			final String template = IOUtils.toString(scriptIn);
			final TemplateResolver r = new TemplateResolver(context);
			return r.resolveStrict(template);
		} catch (IOException exc) {
			throw new RuntimeException("Cannot evaluate script template resource " + templatePath, exc);
		} finally {
			IOUtils.closeQuietly(scriptIn);
		}
	}

	protected int executeWeblogicDeployerScript(StepExecutionContext ctx, HostSession rhs, Map<String, String> velocityContext) {
		String evaluatedScript = generateScript(velocityContext);
		HostFile uploadedDeployScript = rhs.getTempFile("deployitWeblogicDeployer", getExtensionPath());
		uploadedDeployScript.put(IOUtils.toInputStream(evaluatedScript), evaluatedScript.length());
		final String path = uploadedDeployScript.getPath();
		return rhs.execute(new StepExecutionContextCallbackHandler(ctx), path);
	}


	private String getExtensionPath() {
		String wlstExtension;
		final Host activeHost = domain.getActiveHost();
		if (activeHost.getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
			wlstExtension = ".cmd";
		} else {
			wlstExtension = activeHost.getScriptExtension();
		}
		return wlstExtension;
	}


	protected String generateScript(Map<String, String> context) {
		String evaluatedScript = "";
		switch (domain.getActiveHost().getOperatingSystemFamily()) {
			case UNIX:
				return generateWithVelocity(WEBLOGIC_DEPLOYER_UNX_TEMPLATE, context);
			case WINDOWS:
				return generateWithVelocity(WEBLOGIC_DEPLOYER_WIN_TEMPLATE, context);
		}
		throw new RuntimeException("OS is either Unix or Windows");
	}

	protected String findOutExtension(NamedDeployableArtifact artifact) {
		try {
			final Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
			return "." + field.get(artifact).toString();
		} catch (Exception e) {
			throw new RuntimeException("Unexpected artifact " + artifact, e);
		}
	}
}
