/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.container;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.Transformer;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

/**
 * A cluster in a {@link Domain WLS domain}.
 * 
 * @see Server
 */
@SuppressWarnings("serial")
@Metadata(description = "WebLogic Cluster which defines groups of WebLogic servers that work together to increase scalability and reliability")
public class Cluster extends BaseConfigurationItem implements WlsContainer, JmsTarget {

	public static final Transformer TOSTRING_FROM_NAME = new Transformer() {
		public String transform(Object obj) {
			return ((Cluster) obj).getName();
		}
	};

	@Property(required = true, asContainment = true, description = "The domain to which the WebLogic Cluster belongs.  'asContainment'=true, means a Cluster is 'contained' under a Domain")
	private Domain domain;

	@Property(description = "Servers in the WebLogic Cluster")
	private Set<Server> servers = new HashSet<Server>();

	public String getObjectName() {
		return "com.bea:Name=" + getName() + ",Type=Cluster";
	}

	@Inspect
	public void inspect(InspectionPlanningContext ctx) {
		Map<String, Object> pythonVars = newHashMap();
		pythonVars.put("container", this);
		ctx.addStep(new PythonInspectionStep(this, this.getManagingContainer(), "wls/container/inspect-cluster.py", pythonVars, "Inspect " + this));
	}

	@Override
	public Set<Host> getHosts() {
		Set<Host> hosts = Sets.newHashSet();
		for (Server server : servers)
			hosts.addAll(server.getHosts());
		return hosts;
	}

	public Domain getDomain() {
		return domain;
	}

	public void setDomain(Domain domain) {
		this.domain = domain;
	}

	public Set<Server> getServers() {
		return Collections.unmodifiableSet(servers);
	}

	public void setServers(Set<Server> servers) {
		this.servers = servers;
	}

	public void addServer(Server server) {
		this.servers.add(server);
	}

	@Override
    public PythonManagingContainer getManagingContainer() {
	    return domain;
    }

}
