package com.xebialabs.deployit.plugin.wls.container;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

@SuppressWarnings("serial")
@Metadata(description = "WebLogic JMS server, that act as management containers for the queues and topics in JMS modules that are targeted to them")
public class JmsServer extends BaseContainer implements JmsTarget {

	@Property(required = true, asContainment = true, description = "A server instance or migratable target this JMS server is deployed to. 'asContainment'=true, means a JmsServer is 'contained' under a Server")
	private Server server;

	@Override
	public PythonManagingContainer getManagingContainer() {
		return server.getDomain();
	}

	public Server getServer() {
		return server;
	}

	public void setServer(Server server) {
		this.server = server;
	}

	public String getObjectName() {
		return "com.bea:Name=" + getName() + ",Type=JMSServer";
	}

	@Override
    public Domain getDomain() {
	    return server.getDomain();
    }

}
