/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;

@SuppressWarnings("serial")
public class UploadArtifactStep implements DeploymentStep {

	private final int order;
	private final Artifact artifact;
	private final String uploadLocation;
	private final Host host;

	public UploadArtifactStep(int order, Host host, Artifact artifact, String uploadLocation) {
		this.order = order;
		this.host = host;
		this.artifact = artifact;
		this.uploadLocation = uploadLocation;
	}

	@Override
	public String getDescription() {
		return String.format("Upload %s to %s on %s", artifact, uploadLocation, host);
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
		OverthereConnection connection = host.getConnection();
		makeDirectories(ctx, connection);
		uploadArtifact(connection);
		return Result.Success;
	}

	private void makeDirectories(DeploymentExecutionContext ctx, OverthereConnection connection) {
		ctx.logOutput(String.format("Create directory %s (and parent directories) on %s", uploadLocation, host));
		String parentDir = uploadLocation.substring(0, uploadLocation.lastIndexOf(connection.getHostOperatingSystem().getFileSeparator()));
		OverthereFile dir = connection.getFile(parentDir);
		if(!dir.exists()) {
			dir.mkdirs();
		}
	}

	private void uploadArtifact(OverthereConnection connection) {
		final OverthereFile source = artifact.getFile();
		final OverthereFile remote = connection.getFile(uploadLocation);
		OverthereFileCopier.copy(source, remote, null);
	}

	@Override
	public int getOrder() {
		return order;
	}
	
	@Override
	public boolean equals(Object obj) {
		if(obj == this) {
			return true;
		}
	    if(!(obj instanceof UploadArtifactStep)) {
	    	return false;
	    }
	    UploadArtifactStep other = (UploadArtifactStep) obj;
	    return artifact.equals(other.artifact) && host.equals(other.host) && uploadLocation.equals(other.uploadLocation);
	}
	
	@Override
	public int hashCode() {
		int result = 17;
		result = 31*result + artifact.hashCode();
		result = 31*result + host.hashCode();
		result = 31*result + uploadLocation.hashCode();
		return result;
	}

}
