package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;

@SuppressWarnings("serial")
public class WaitingStep implements DeploymentStep {

	private final long waitTime;
	private int order;

	public WaitingStep(int order, long time) {
		if (time < 0)
			throw new RuntimeException("negative values invalid (" + time + ")");
		this.waitTime = time;
		this.order = order;
	}

	@Override
	public String getDescription() {
		return "Wait for " + this.waitTime + " second(s)";
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
		try {
			Thread.sleep(waitTime * 1000);
		} catch (InterruptedException e) {
			ctx.logError("Interrupted!", e);
			Thread.currentThread().interrupt();
			return Result.Fail;
		}

		ctx.logOutput("Done waiting");
		return Result.Success;
	}

	public long getWaitTime() {
		return waitTime;
	}

	@Override
	public int getOrder() {
		return order;
	}
}
