#######Possible resources in a JmsModule ########
# TODO: Need to find out a better and dynamic way to find out resources instead of a hard-coded names(which might differ from version to version)
# ConnectionFactories,DestinationKeys,DistributedQueues,DistributedTopics,ForeignServers,Queues,Quotas,SAFErrorHandlings,
# SAFImportedDestinations,SAFRemoteContexts,Templates,Topics,UniformDistributedQueues,UniformDistributedTopics
#################################################
def getResourcesUsingJmsModule(jmsModuleName):
    jmsSystemResources = cmo.getJMSSystemResources();
    resourceList = []
    resourceNames = []
    
    for jmsSystemResource in jmsSystemResources:
        if jmsSystemResource.getName() == jmsModuleName:
            resourceList.extend(jmsSystemResource.getJMSResource().getQueues());
            resourceList.extend(jmsSystemResource.getJMSResource().getTopics());
            resourceList.extend(jmsSystemResource.getJMSResource().getConnectionFactories());
            resourceList.extend(jmsSystemResource.getJMSResource().getDistributedQueues())
            resourceList.extend(jmsSystemResource.getJMSResource().getDistributedTopics());
            resourceList.extend(jmsSystemResource.getJMSResource().getUniformDistributedQueues());
            resourceList.extend(jmsSystemResource.getJMSResource().getUniformDistributedTopics());
            print 'jmsSystemResource: %s' %(jmsSystemResource)
            
            for eachResource in resourceList:
               resourceNames.append(eachResource.getName())
    return resourceNames 


resourcesUsingThisModule = getResourcesUsingJmsModule(jmsModuleName)
if len(resourcesUsingThisModule) != 0:
    print "Will not destroy jms module %s: It is in use by resources: %s" %(jmsModuleName, resourcesUsingThisModule)
else:
    print "Destroying JMS Module " + jmsModuleName
    edit()
    startEdit()
    cmo.destroyJMSSystemResource(getMBean('/SystemResources/' + jmsModuleName))
    saveAndActivate()
