/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArchiveArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class WlsArtifactProcessor {
    @PrePlanProcessor
    public Step<?> setVersionIdentifiers(DeltaSpecification spec) {
        String appVersion = spec.getDeployedApplication().getVersion().getVersion();
        String appName = spec.getDeployedApplication().getVersion().getApplication().getName();
        String defaultVersion = appName + "-" + appVersion;
        for (Delta delta : spec.getDeltas()) {
            Deployed deployed = delta.getDeployed();
            if (!(deployed instanceof ExtensibleDeployedArtifact)) continue;
            this.setVersionIdentifier((ExtensibleDeployedArtifact)deployed, defaultVersion);
        }
        return null;
    }

    private void setVersionIdentifier(ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact> deployed, String defaultVersion) {
        Artifact artifact = (Artifact)deployed.getDeployable();
        if (deployed.isVersioned()) {
            File manifestFile = ((LocalFile)artifact.getFile()).getFile();
            Manifest manifest = this.readManifest(manifestFile);
            Attributes mainAttributes = manifest.getMainAttributes();
            String extName = mainAttributes.getValue("Extension-Name");
            if (StringUtils.isBlank((String)extName)) {
                deployed.setVersionIdentifier(defaultVersion);
                return;
            }
            String specVersion = mainAttributes.getValue("Specification-Version");
            String implVersion = mainAttributes.getValue("Implementation-Version");
            deployed.setVersionIdentifier(StringUtils.isBlank((String)implVersion) ? specVersion : specVersion + "@" + implVersion);
        }
    }

    private Manifest readManifest(File archiveFile) {
        Manifest manifest;
        JarInputStream in = null;
        try {
            in = new JarInputStream(new FileInputStream(archiveFile));
            manifest = in.getManifest();
        }
        catch (IOException exception) {
            try {
                throw new RuntimeException("Cannot read manifest file " + archiveFile, exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return manifest;
    }
}

