queueName = deployed.name
jmsModuleName = deployed.jmsModuleName
jmsServerName = deployed.container.name
wlsServerName = deployed.container.server.name

print "Checking state of server " + wlsServerName
cd('domainRuntime:/ServerLifeCycleRuntimes/' + wlsServerName)
if cmo.getState() == "RUNNING":
	print "Checking whether JMS Queue " + queueName + " running on server " + wlsServerName + " contains any messages"
	cd('domainRuntime:/ServerRuntimes/' + wlsServerName + '/JMSRuntime/' + wlsServerName + '.jms/JMSServers/' + jmsServerName + '/Destinations/' + jmsModuleName + '!' + queueName)
	currentNumberOfMessages = cmo.getMessagesCurrentCount()
	if (currentNumberOfMessages != 0):
		print "The queue is not empty. It contains " + str(currentNumberOfMessages) + " messages and can not be destroyed"
		sys.exit(1)

print "Destroying JMS Queue " + queueName + " in JMS Module " + jmsModuleName
cd('serverConfig:/')
edit()
startEdit()
cd('/JMSSystemResources/' + jmsModuleName + '/Resource/' + jmsModuleName + '/Queues')
cmo.destroyQueue(getMBean(queueName))

saveAndExit()
