/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JmsModuleDestructor {
    private static final String DESTROY_WLS_JMS_MODULE = "wls/jms/cleanup-jms-module.py";

    @Contributor
    public void destroyJmsModule(Deltas deltas, DeploymentPlanningContext ctx) {
        Multimap<String, Domain> jmsModulesToBeDestroyed = this.populateModuleDeltasMap(deltas);
        for (String eachModule : jmsModulesToBeDestroyed.keySet()) {
            Collection domainsToRemoveFrom = jmsModulesToBeDestroyed.get((Object)eachModule);
            for (Domain eachDomain : domainsToRemoveFrom) {
                this.addStepToRemoveJmsModuleFromDomain(ctx, eachModule, eachDomain);
            }
        }
    }

    private void addStepToRemoveJmsModuleFromDomain(DeploymentPlanningContext ctx, String eachModule, Domain eachDomain) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("jmsModuleName", eachModule);
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(100, (PythonManagingContainer)eachDomain, DESTROY_WLS_JMS_MODULE, (Map)pythonVars, "Cleaning up jms module:" + eachModule + " in domain:" + (Object)((Object)eachDomain)));
    }

    private Multimap<String, Domain> populateModuleDeltasMap(Deltas deltas) {
        HashMultimap moduleOperationsMap = HashMultimap.create();
        for (Delta each : deltas.getDeltas()) {
            Deployed deployed;
            if (each.getOperation() != Operation.DESTROY && each.getOperation() != Operation.MODIFY) continue;
            Deployed deployed2 = deployed = each.getPrevious() != null ? each.getPrevious() : each.getDeployed();
            if (!JmsResource.class.isAssignableFrom(each.getPrevious().getClass())) continue;
            String jmsModuleName = ((JmsResource)deployed).getJmsModuleName();
            moduleOperationsMap.put((Object)jmsModuleName, (Object)((JmsTarget)deployed.getContainer()).getDomain());
        }
        return moduleOperationsMap;
    }
}

