/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.Server;
import java.util.Set;

@Metadata(description="WebLogic JMS server, that act as management containers for the queues and topics in JMS modules that are targeted to them")
public class JmsServer
extends BaseContainer
implements JmsTarget {
    @Property(description="The tags to map deployables to containers.", required=false)
    private Set<String> tags = Sets.newHashSet();
    @Property(required=true, asContainment=true, description="A server instance or migratable target this JMS server is deployed to. 'asContainment'=true, means a JmsServer is 'contained' under a Server")
    private Server server;

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> set) {
        this.tags = set;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.server.getDomain();
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=JMSServer";
    }

    @Override
    public Domain getDomain() {
        return this.server.getDomain();
    }
}

