/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JmsModuleDestructor {
    private static final String DESTROY_WLS_JMS_MODULE = "wls/jms/cleanup-jms-module.py";

    @Contributor
    public void destroyJmsModule(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Multimap<String, Domain> multimap = this.populateModuleDeltasMap(deltas);
        for (String string : multimap.keySet()) {
            Collection collection = multimap.get((Object)string);
            for (Domain domain : collection) {
                this.addStepToRemoveJmsModuleFromDomain(deploymentPlanningContext, string, domain);
            }
        }
    }

    private void addStepToRemoveJmsModuleFromDomain(DeploymentPlanningContext deploymentPlanningContext, String string, Domain domain) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("jmsModuleName", string);
        deploymentPlanningContext.addStep((DeploymentStep)new PythonDeploymentStep(100, (PythonManagingContainer)domain, DESTROY_WLS_JMS_MODULE, (Map)hashMap, "Cleaning up jms module:" + string + " in domain:" + (Object)((Object)domain)));
    }

    private Multimap<String, Domain> populateModuleDeltasMap(Deltas deltas) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (Delta delta : deltas.getDeltas()) {
            Deployed deployed;
            if (delta.getOperation() != Operation.DESTROY && delta.getOperation() != Operation.MODIFY) continue;
            Deployed deployed2 = deployed = delta.getPrevious() != null ? delta.getPrevious() : delta.getDeployed();
            if (!JmsResource.class.isAssignableFrom(delta.getPrevious().getClass())) continue;
            String string = ((JmsResource)deployed).getJmsModuleName();
            hashMultimap.put((Object)string, (Object)((JmsTarget)deployed.getContainer()).getDomain());
        }
        return hashMultimap;
    }
}

