/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.StageMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.ArtifactDeploymentContributor;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashSet;
import java.util.Map;

@Metadata(virtual=true, description="Base class for all deployeds meant to contain Applications")
@Placeholders
public class ExtensibleDeployedArtifact<D extends DeployableArtifact>
extends PythonManagedDeployed<D, WlsContainer>
implements DerivedArtifact<DeployableArtifact> {
    static final int NO_RETIREMENT_TIMEOUT = -1;
    public static final Type DEPLOYED_SHARED_LIB_WAR = Type.valueOf((String)"wls", (String)"SharedLibraryWarModule");
    @Property(defaultValue="Stage", required=false, description="Indicates whether the artifact will be deployed as staged or nostage mode")
    private StageMode stageMode;
    @Property(required=false, description="Absolute directory path where the artifact will be uploaded and used by the servers for nostage deployment mode")
    private String stagingDirectory;
    @Property(required=false, description="Indicates wither this artifact is to be deployed as a versioned application")
    private boolean versioned = false;
    @Property(required=true, defaultValue="CLASSIC", description="Indicates what redeployment strategy to use for upgrading the application")
    private DeploymentStrategy redeploymentStrategy;
    @Property(required=false, defaultValue="-1", description="Timeout interval (in secs) before the previous application version is undeployed for side by side redeployment strategy")
    private int retireTimeout;
    @Property(required=false)
    private String versionIdentifier;
    @Property(hidden=true, defaultValue="id, name, type, deployable, properties, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, startScript, startVerb, startOrder, stopScript, stopVerb, stopOrder, deploymentStrategy, placeholders, file, redeploymentStrategy, securityPermissions, inheritPermissions, exposeDeployedApplication, stopRetiredApplicationOrder, undeployRetiredApplicationOrder")
    private String standardPropertiesNotToExpose;
    @Property(description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();
    @Property(hidden=true, required=false, description="Python script invoked to deploy this Java EE artifact")
    private String createScript;
    @Property(hidden=true, defaultValue="Deploy")
    private String createVerb;
    @Property(hidden=true, defaultValue="70")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this Java EE artifact")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to undeploy this Java EE artifact")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Undeploy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="30")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="98")
    private int undeployRetiredApplicationOrder;
    @Property(hidden=true, defaultValue="95")
    private int stopRetiredApplicationOrder;
    @Property(hidden=true, required=false, description="Python script invoked to start this Java EE artifact")
    private String startScript;
    @Property(hidden=true, defaultValue="Start")
    private String startVerb;
    @Property(hidden=true, defaultValue="90")
    private int startOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop this Java EE artifact")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop")
    private String stopVerb;
    @Property(hidden=true, defaultValue="10")
    private int stopOrder;
    private OverthereFile derivedFile;
    private Map<String, Object> pythonVars = Maps.newHashMap();

    @Create
    public void deployArtifact(DeploymentPlanningContext deploymentPlanningContext) {
        this.deployWeblogicArtifact(deploymentPlanningContext);
        this.setRetireTimeout(-1);
    }

    void deployWeblogicArtifact(DeploymentPlanningContext deploymentPlanningContext) {
        this.validateDeployedFields();
        this.handleCopyArtifact(deploymentPlanningContext);
        this.addStep(deploymentPlanningContext, this.createOrder, this.createScript, this.createVerb);
    }

    @Modify
    public void modifyArtifact(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        Object object;
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStep(deploymentPlanningContext, this.modifyOrder, this.modifyScript, this.modifyVerb);
        } else {
            object = (ExtensibleDeployedArtifact)delta.getPrevious();
            ExtensibleDeployedArtifact extensibleDeployedArtifact = (ExtensibleDeployedArtifact)delta.getDeployed();
            this.validateModifiedDeployed((ExtensibleDeployedArtifact<DeployableArtifact>)((Object)object), extensibleDeployedArtifact);
            ((ExtensibleDeployedArtifact)((Object)object)).destroyArtifact(deploymentPlanningContext, delta);
            extensibleDeployedArtifact.deployWeblogicArtifact(deploymentPlanningContext);
        }
        if (this.getRedeploymentStrategy().equals((Object)DeploymentStrategy.SIDE_BY_SIDE)) {
            object = this.getRetireTimeout();
            ArtifactDeploymentContributor.setWaitStepInterval(deploymentPlanningContext, ((Integer)object).intValue());
        } else {
            this.setProperty("retireTimeout", -1);
        }
    }

    @Destroy
    public void destroyArtifact(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        int n = this.destroyOrder;
        if (delta.getOperation() == Operation.MODIFY && ((ExtensibleDeployedArtifact)delta.getDeployed()).getRedeploymentStrategy().equals((Object)DeploymentStrategy.SIDE_BY_SIDE)) {
            n = this.undeployRetiredApplicationOrder;
        }
        this.addStep(deploymentPlanningContext, n, this.destroyScript, this.destroyVerb, false);
        this.handleDeleteArtifact(deploymentPlanningContext, this.destroyOrder);
    }

    private boolean isStartOrStopOperationRequired() {
        if (DEPLOYED_SHARED_LIB_WAR.equals((Object)this.getType())) {
            return false;
        }
        return this.getRedeploymentStrategy() != DeploymentStrategy.STOP_START;
    }

    @Create
    @Modify
    public void startApplication(DeploymentPlanningContext deploymentPlanningContext) {
        if (this.isStartOrStopOperationRequired()) {
            this.addStep(deploymentPlanningContext, this.startOrder, this.startScript, this.startVerb, false);
        }
    }

    @Modify
    public void stopApplicationForModifedArtifact(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        if (!this.isStartOrStopOperationRequired()) {
            return;
        }
        ExtensibleDeployedArtifact extensibleDeployedArtifact = (ExtensibleDeployedArtifact)delta.getPrevious();
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            extensibleDeployedArtifact.addStep(deploymentPlanningContext, this.stopRetiredApplicationOrder, this.stopScript, this.stopVerb, false);
        } else {
            extensibleDeployedArtifact.addStep(deploymentPlanningContext, this.stopOrder, this.stopScript, this.stopVerb, false);
        }
    }

    @Destroy
    public void stopApplication(DeploymentPlanningContext deploymentPlanningContext) {
        if (this.isStartOrStopOperationRequired()) {
            this.addStep(deploymentPlanningContext, this.stopOrder, this.stopScript, this.stopVerb, false);
        }
    }

    protected String getDescription(String string) {
        if (Artifact.class.isAssignableFrom(((DeployableArtifact)this.getDeployable()).getClass())) {
            return String.format("%s %s on %s", string, ((DeployableArtifact)this.getDeployable()).getFile().getName(), ((WlsContainer)this.getContainer()).getName());
        }
        return super.getDescription(string);
    }

    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        this.pythonVars.putAll(super.getPythonVars(deployedApplication));
        return this.pythonVars;
    }

    private void validateModifiedDeployed(ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact, ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact2) {
        String string;
        String string2;
        this.validateDeployedFields();
        if (this.isNoStageMode() && (string2 = extensibleDeployedArtifact.getStagingDirectory()).equals(string = extensibleDeployedArtifact2.getStagingDirectory())) {
            throw new RuntimeException("Can't deploy a new version to " + string + ". This is same as the previous deployment nostage directory!");
        }
    }

    private void validateDeployedFields() {
        if (this.isNoStageMode()) {
            if (Strings.isNullOrEmpty((String)this.getStagingDirectory())) {
                throw new RuntimeException("Staging directory shouldn't be blank");
            }
            if (((WlsContainer)this.getContainer()).getHosts() == null) {
                throw new RuntimeException("NoStage deployment: the target " + this.getContainer() + " contains no hosts, check your repository");
            }
        }
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE && !this.isVersioned()) {
            throw new RuntimeException("SIDE_BY_SIDE deployment strategy is only applicable for versioned deployment");
        }
    }

    protected void handleCopyArtifact(DeploymentPlanningContext deploymentPlanningContext) {
        if (this.isNoStageMode()) {
            HashSet<Host> hashSet = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            hashSet.add(((WlsContainer)this.getContainer()).getDomain().getHost());
            String string = this.getRemoteDestinationFilename((Host)hashSet.iterator().next());
            for (Host host : hashSet) {
                ArtifactDeploymentContributor.addUploadArtifactStep(deploymentPlanningContext, new UploadArtifactStep(68, host, (Artifact)this.getDeployable(), string));
            }
            this.pythonVars.put("remoteDestinationFilename", string);
        }
    }

    protected void handleDeleteArtifact(DeploymentPlanningContext deploymentPlanningContext, int n) {
        if (this.isNoStageMode()) {
            HashSet<Host> hashSet = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            hashSet.add(((WlsContainer)this.getContainer()).getDomain().getHost());
            for (Host host : hashSet) {
                ArtifactDeploymentContributor.addDeleteArtifactStep(deploymentPlanningContext, new DeleteArtifactStep(n, host, this.getRemoteDestinationFilename(host)));
            }
        }
    }

    private String getRemoteDestinationFilename(Host host) {
        return this.getStagingDirectory() + host.getOs().getFileSeparator() + ((DeployableArtifact)this.getDeployable()).getFile().getName();
    }

    private boolean isNoStageMode() {
        return this.getStageMode().equals((Object)StageMode.NoStage);
    }

    public StageMode getStageMode() {
        return this.stageMode;
    }

    public void setStageMode(StageMode stageMode) {
        this.stageMode = stageMode;
    }

    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    public void setStagingDirectory(String string) {
        this.stagingDirectory = string;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String string) {
        this.versionIdentifier = string;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public void setVersioned(boolean bl) {
        this.versioned = bl;
    }

    public DeploymentStrategy getRedeploymentStrategy() {
        return this.redeploymentStrategy;
    }

    public int getRetireTimeout() {
        return this.retireTimeout;
    }

    public void setRetireTimeout(int n) {
        this.retireTimeout = n;
    }

    public void setRedeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.redeploymentStrategy = deploymentStrategy;
    }

    public OverthereFile getFile() {
        return this.derivedFile;
    }

    public void setFile(OverthereFile overthereFile) {
        this.derivedFile = overthereFile;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> map) {
        this.placeholders = map;
    }

    public void initFile(PlaceholderReplacer placeholderReplacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)placeholderReplacer);
    }
}

