/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;

public class WaitingStep
implements DeploymentStep {
    private final long waitTime;
    private int order;

    public WaitingStep(int n, long l) {
        if (l < 0L) {
            throw new RuntimeException("negative values invalid (" + l + ")");
        }
        this.waitTime = l;
        this.order = n;
    }

    public String getDescription() {
        return "Wait for " + this.waitTime + " second(s)";
    }

    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        try {
            Thread.sleep(this.waitTime * 1000L);
        }
        catch (InterruptedException interruptedException) {
            deploymentExecutionContext.logError("Interrupted!", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
            return Step.Result.Fail;
        }
        deploymentExecutionContext.logOutput("Done waiting");
        return Step.Result.Success;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public int getOrder() {
        return this.order;
    }
}

