package com.xebialabs.deployit.plugin.wls.contributor;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArchiveArtifact;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.StartMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LifeCycleContributor {

	@Contributor
	public void stopContainers(Deltas deltas, DeploymentPlanningContext result) {
		Set<WlsContainer> targets = gatherTargets(deltas.getDeltas());
		for (WlsContainer target : targets) {
			result.addStep(new StopWlsTargetStep(target.getStopOrder(), target));
		}
	}


	@Contributor
	public void startContainers(Deltas deltas, DeploymentPlanningContext result) {
		Set<WlsContainer> targets = gatherTargets(deltas.getDeltas());
		for (WlsContainer target : targets) {
			final StartMode startMode = target.getDomain().getStartMode();
			switch (startMode) {
				case NodeManager:
					result.addStep(new StartWlsTargetStep(target.getStartOrder(), target));
					break;
				case Script:
					for (Server server : target.getServers())
						result.addStep(new StartWlsServerWithScriptStep(target.getStartOrder(), server));
					break;
				case WindowsService:
					throw new RuntimeException("The Windows Service mode has not been implemented yet");
			}
		}
	}

    private Set<WlsContainer> gatherTargets(List<Delta> operations) {
		final Set<WlsContainer> wlsTargets = new HashSet<WlsContainer>();
		for (Delta operation : operations) {
			addTarget(wlsTargets, operation.getDeployed());
			addTarget(wlsTargets, operation.getPrevious());
		}
		return wlsTargets;
	}

	@SuppressWarnings("unchecked")
    private void addTarget(Set<WlsContainer> wlsTargets, Deployed<?, ?> deployed) {
		if (deployed == null)
			return;
		//TODO: WlsResourceDeployed too
		if (deployed instanceof ExtensibleDeployedArtifact) {
			ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact> deployedArtifact = (ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact>) deployed;
			final DeploymentStrategy deploymentStrategy = deployedArtifact.getRedeploymentStrategy();
			if (deploymentStrategy == DeploymentStrategy.STOP_START) {
				wlsTargets.add((WlsContainer) deployed.getContainer());
			}
		}
	}


}
