/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;

@Metadata(virtual=true, description="Base class for all JMS destinations, which can have a error destination property defined on them")
public class JmsDestination<D extends JmsResourceSpec, C extends JmsTarget, E extends JmsDestination>
extends JmsResource<D, C> {
    @Property(required=false, category="Delivery Failure", description="Target error destination for messages that have expired or reached their redelivery limit")
    private E errorDestination;
    @Property(hidden=true, defaultValue="id, name, type, properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, securityPermissions, inheritPermissions, exposeDeployedApplication, jndiName, jmsModuleName, subDeploymentName, errorDestination, setErrorDestinationScript, setErrorDestinationVerb, setErrorDestinationOrder, unsetErrorDestinationVerb, unsetErrorDestinationOrder, unsetErrorDestinationScript")
    private String standardPropertiesNotToExpose;
    @Property(hidden=true, required=false, description="Python script invoked to set error destination on this jms resource")
    private String setErrorDestinationScript;
    @Property(hidden=true, defaultValue="Set error queue for")
    private String setErrorDestinationVerb;
    @Property(hidden=true, defaultValue="61")
    private int setErrorDestinationOrder;
    @Property(hidden=true, required=false, description="Python script invoked to unset error destination from this jms resource")
    private String unsetErrorDestinationScript;
    @Property(hidden=true, defaultValue="Unset error queue from =")
    private String unsetErrorDestinationVerb;
    @Property(hidden=true, defaultValue="37")
    private int unsetErrorDestinationOrder;

    public E getErrorDestination() {
        return this.errorDestination;
    }

    public void setErrorDestination(E errorDestination) {
        this.errorDestination = errorDestination;
    }

    @Create
    @Modify
    public void setErrorQueue(DeploymentPlanningContext result) {
        this.validate();
        if (this.hasErrorQueue()) {
            this.addStep(result, this.setErrorDestinationOrder, this.setErrorDestinationScript, this.setErrorDestinationVerb);
        }
    }

    @Destroy
    @Modify
    public void unsetErrorQueue(DeploymentPlanningContext result, Delta delta) {
        JmsDestination previous = (JmsDestination)delta.getPrevious();
        if (this.hasErrorQueue() && previous.hasErrorQueue()) {
            this.addStep(result, this.unsetErrorDestinationOrder, this.unsetErrorDestinationScript, this.unsetErrorDestinationVerb);
        }
    }

    private boolean hasErrorQueue() {
        return this.getErrorDestination() != null;
    }

    void validate() {
        if (this.hasErrorQueue()) {
            E errorQueue = this.getErrorDestination();
            if (errorQueue == this) {
                throw new RuntimeException(String.format("Jms destination %s can't be set as the error-destination of itself", this.getName()));
            }
            if (!((JmsTarget)this.getContainer()).equals(this.getErrorDestination().getContainer())) {
                throw new RuntimeException(String.format("Jms destination %s and it's error destination %s should be targeted to the same containers", this.getName(), this.getErrorDestination().getName()));
            }
            if (!this.getJmsModuleName().equals(((JmsResource)((Object)errorQueue)).getJmsModuleName())) {
                throw new RuntimeException(String.format("Jms destination %s and it's error destination %s should belong to the same jms module", this.getName(), errorQueue.getName()));
            }
        }
    }
}

