package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.wls.container.Server;

import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.ImmutableMap.of;
import static com.xebialabs.deployit.plugin.api.utils.Strings.isNotBlank;

@SuppressWarnings("serial")
public class StartWlsServerWithScriptStep extends ScriptExecutionStep implements DeploymentStep {

	public StartWlsServerWithScriptStep(int order, Server server) {
		super(order, (String) server.getProperty("startScript"), server.getHost(), of("container", (Object) server), getDescription(server));
		checkState(isNotBlank(server.getStartCommand()), "startCommand is blank for " + server);
		checkState(server.getHost() != null, "Can only start a wls.Server with a script when it its host property has been set");
	}

	private static String getDescription(Server server) {
		return String.format("Start Weblogic server %s using a script", server);
	}
}
