/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Metadata(virtual=true, description="Base class for all deployeds meant to contain Applications")
@Placeholders
public class CopiedArtifact<D extends DeployableArtifact, C extends WlsContainer>
extends BaseDeployed<D, C>
implements DerivedArtifact<DeployableArtifact> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    private OverthereFile placeholderProcessedFile;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(description="Path to which artifact must be copied to on the wls server.")
    private String targetDirectory;
    @Property(defaultValue="true", description="Is the target directory shared by others on the wls server. When true, the target directory is not deleted during a destroy operation; only the artifacts copied to it.", required=false)
    private boolean targetDirectoryShared;
    @Property(defaultValue="false", description="Create the target directory on the wls server if it does not exist.", required=false)
    private boolean createTargetDirectory;
    @Property(required=false, description="Name of the artifact on the wls server.")
    private String targetFile;
    @Property(defaultValue="false", description="Restart the target container", required=false)
    private boolean restartTarget;
    @Property(description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addSteps(this.createArtifactCopyStep());
    }

    protected Collection<DeploymentStep> createArtifactCopyStep() {
        WlsContainer wlsContainer = (WlsContainer)this.getContainer();
        return Collections2.transform(wlsContainer.getHosts(), (Function)new Function<Host, DeploymentStep>(){

            public ArtifactCopyStep apply(Host host) {
                ArtifactCopyStep artifactCopyStep = new ArtifactCopyStep(CopiedArtifact.this.getCreateOrder(), CopiedArtifact.this.getFile(), (HostContainer)host, CopiedArtifact.this.getTargetDirectory());
                artifactCopyStep.setCreateTargetPath(CopiedArtifact.this.isCreateTargetDirectory());
                artifactCopyStep.setTargetFileName(CopiedArtifact.this.resolveTargetFileName());
                artifactCopyStep.setSourceFileDescription(((DeployableArtifact)CopiedArtifact.this.getDeployable()).getName());
                artifactCopyStep.setDescription(CopiedArtifact.this.getDescription("Copy"));
                return artifactCopyStep;
            }
        });
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addSteps(this.createArtifactDeleteStep());
    }

    protected Collection<DeploymentStep> createArtifactDeleteStep() {
        WlsContainer wlsContainer = (WlsContainer)this.getContainer();
        return Collections2.transform(wlsContainer.getHosts(), (Function)new Function<Host, DeploymentStep>(){

            public ArtifactDeleteStep apply(Host host) {
                ArtifactDeleteStep artifactDeleteStep = new ArtifactDeleteStep(CopiedArtifact.this.getDestroyOrder(), (HostContainer)host, (DeployableArtifact)CopiedArtifact.this.getDeployable(), CopiedArtifact.this.getTargetDirectory());
                artifactDeleteStep.setTargetDirectoryShared(CopiedArtifact.this.isTargetDirectoryShared());
                artifactDeleteStep.setTargetFile(CopiedArtifact.this.resolveTargetFileName());
                artifactDeleteStep.setDescription(CopiedArtifact.this.getDescription("Delete"));
                return artifactDeleteStep;
            }
        });
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        CopiedArtifact copiedArtifact = (CopiedArtifact)delta.getPrevious();
        copiedArtifact.executeDestroy(deploymentPlanningContext);
        this.executeCreate(deploymentPlanningContext);
    }

    public String getTargetDirectory() {
        return this.resolveExpression(this.targetDirectory);
    }

    public String getTargetFile() {
        return this.resolveExpression(this.targetFile);
    }

    public void setTargetFile(String string) {
        this.targetFile = string;
    }

    public boolean isCreateTargetDirectory() {
        return this.createTargetDirectory;
    }

    public void setCreateTargetDirectory(boolean bl) {
        this.createTargetDirectory = bl;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean bl) {
        this.targetDirectoryShared = bl;
    }

    public String resolveExpression(String string) {
        return ConfigurationHolder.resolveExpression((String)string, this.getDeployedAsFreeMarkerContext());
    }

    public Map<String, Object> getDeployedAsFreeMarkerContext() {
        return this.freeMarkerContext;
    }

    protected String resolveTargetFileName() {
        return Strings.nullToEmpty((String)this.getTargetFile()).trim().isEmpty() ? ((DeployableArtifact)this.getDeployable()).getName() : this.getTargetFile();
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int n) {
        this.createOrder = n;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int n) {
        this.destroyOrder = n;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile overthereFile) {
        this.placeholderProcessedFile = overthereFile;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> map) {
        this.placeholders = map;
    }

    public void initFile(PlaceholderReplacer placeholderReplacer) {
        Artifacts.replacePlaceholders((DerivedArtifact)this, (PlaceholderReplacer)placeholderReplacer);
    }

    public String getDescription(String string) {
        return String.format("%s %s on %s", string, ((DeployableArtifact)this.getDeployable()).getName(), ((WlsContainer)this.getContainer()).getName());
    }
}

