/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.Closeable;

public class UploadArtifactStep
implements DeploymentStep {
    private final int order;
    private final Artifact artifact;
    private final String uploadLocation;
    private final Host host;

    public UploadArtifactStep(int n, Host host, Artifact artifact, String string) {
        this.order = n;
        this.host = host;
        this.artifact = artifact;
        this.uploadLocation = string;
    }

    public String getDescription() {
        return String.format("Upload %s to %s on %s", this.artifact, this.uploadLocation, this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        OverthereConnection overthereConnection = this.host.getConnection();
        try {
            this.makeDirectories(deploymentExecutionContext, overthereConnection);
            this.uploadArtifact(overthereConnection);
        }
        finally {
            Closeables.closeQuietly((Closeable)overthereConnection);
        }
        return Step.Result.Success;
    }

    private void makeDirectories(DeploymentExecutionContext deploymentExecutionContext, OverthereConnection overthereConnection) {
        deploymentExecutionContext.logOutput(String.format("Create directory %s (and parent directories) on %s", this.uploadLocation, this.host));
        String string = this.uploadLocation.substring(0, this.uploadLocation.lastIndexOf(overthereConnection.getHostOperatingSystem().getFileSeparator()));
        OverthereFile overthereFile = overthereConnection.getFile(string);
        if (!overthereFile.exists()) {
            overthereFile.mkdirs();
        }
    }

    private void uploadArtifact(OverthereConnection overthereConnection) {
        OverthereFile overthereFile = this.artifact.getFile();
        OverthereFile overthereFile2 = overthereConnection.getFile(this.uploadLocation);
        OverthereFileCopier.copy((OverthereFile)overthereFile, (OverthereFile)overthereFile2);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UploadArtifactStep)) {
            return false;
        }
        UploadArtifactStep uploadArtifactStep = (UploadArtifactStep)object;
        return this.artifact.equals(uploadArtifactStep.artifact) && this.host.equals((Object)uploadArtifactStep.host) && this.uploadLocation.equals(uploadArtifactStep.uploadLocation);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.artifact.hashCode();
        n = 31 * n + this.host.hashCode();
        n = 31 * n + this.uploadLocation.hashCode();
        return n;
    }
}

