/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Metadata(virtual=true, description="Base class for all deployeds meant to contain Applications")
@Placeholders
public class CopiedArtifact<D extends DeployableArtifact, C extends WlsContainer>
extends BaseDeployed<D, C>
implements DerivedArtifact<DeployableArtifact> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    private OverthereFile placeholderProcessedFile;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(description="Path to which artifact must be copied to on the wls server.")
    private String targetDirectory;
    @Property(defaultValue="true", description="Is the target directory shared by others on the wls server. When true, the target directory is not deleted during a destroy operation; only the artifacts copied to it.", required=false)
    private boolean targetDirectoryShared;
    @Property(defaultValue="false", description="Create the target directory on the wls server if it does not exist.", required=false)
    private boolean createTargetDirectory;
    @Property(required=false, description="Name of the artifact on the wls server.")
    private String targetFile;
    @Property(defaultValue="false", description="Restart the target container", required=false)
    private boolean restartTarget;
    @Property(category="Placeholders", description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        ArtifactCopyStep last = null;
        for (ArtifactCopyStep step : this.createArtifactCopyStep()) {
            ctx.addStep((Step)step);
            last = step;
        }
        if (last != null) {
            ctx.addCheckpoint(last, delta, Operation.CREATE);
        }
    }

    protected Collection<ArtifactCopyStep> createArtifactCopyStep() {
        WlsContainer container = (WlsContainer)this.getContainer();
        return Collections2.transform(container.getHosts(), (Function)new Function<Host, ArtifactCopyStep>(){

            public ArtifactCopyStep apply(Host input) {
                ArtifactCopyStep step = new ArtifactCopyStep(CopiedArtifact.this.getCreateOrder(), CopiedArtifact.this.getFile(), (HostContainer)input, CopiedArtifact.this.getTargetDirectory());
                step.setCreateTargetPath(CopiedArtifact.this.isCreateTargetDirectory());
                step.setTargetFileName(CopiedArtifact.this.resolveTargetFileName());
                step.setSourceFileDescription(((DeployableArtifact)CopiedArtifact.this.getDeployable()).getName());
                step.setDescription(CopiedArtifact.this.getDescription("Copy"));
                return step;
            }
        });
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        ArtifactDeleteStep last = null;
        for (ArtifactDeleteStep step : this.createArtifactDeleteStep()) {
            ctx.addStep((Step)step);
            last = step;
        }
        if (last != null) {
            ctx.addCheckpoint(last, delta, Operation.DESTROY);
        }
    }

    protected Collection<ArtifactDeleteStep> createArtifactDeleteStep() {
        WlsContainer container = (WlsContainer)this.getContainer();
        return Collections2.transform(container.getHosts(), (Function)new Function<Host, ArtifactDeleteStep>(){

            public ArtifactDeleteStep apply(Host input) {
                ArtifactDeleteStep step = new ArtifactDeleteStep(CopiedArtifact.this.getDestroyOrder(), (HostContainer)input, (DeployableArtifact)CopiedArtifact.this.getDeployable(), CopiedArtifact.this.getTargetDirectory());
                step.setTargetDirectoryShared(CopiedArtifact.this.isTargetDirectoryShared());
                step.setTargetFile(CopiedArtifact.this.resolveTargetFileName());
                step.setDescription(CopiedArtifact.this.getDescription("Delete"));
                return step;
            }
        });
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        CopiedArtifact old = (CopiedArtifact)delta.getPrevious();
        old.executeDestroy(ctx, delta);
        this.executeCreate(ctx, delta);
    }

    public String getTargetDirectory() {
        return this.resolveExpression(this.targetDirectory);
    }

    public String getTargetFile() {
        return this.resolveExpression(this.targetFile);
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isCreateTargetDirectory() {
        return this.createTargetDirectory;
    }

    public void setCreateTargetDirectory(boolean createTargetDirectory) {
        this.createTargetDirectory = createTargetDirectory;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }

    public String resolveExpression(String expression) {
        return ConfigurationHolder.resolveExpression((String)expression, this.getDeployedAsFreeMarkerContext());
    }

    public Map<String, Object> getDeployedAsFreeMarkerContext() {
        return this.freeMarkerContext;
    }

    protected String resolveTargetFileName() {
        return Strings.nullToEmpty((String)this.getTargetFile()).trim().isEmpty() ? ((DeployableArtifact)this.getDeployable()).getName() : this.getTargetFile();
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public String getDescription(String verb) {
        return String.format("%s %s on %s", verb, ((DeployableArtifact)this.getDeployable()).getName(), ((WlsContainer)this.getContainer()).getName());
    }
}

