/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.validator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.JmsServer;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractQueue;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractUniformDistributedQueue;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PlanLevelValidator {
    @PrePlanProcessor
    public Step validatePlan(DeltaSpecification spec) {
        PlanLevelValidator.validateArtifactDeploymentOptions(spec);
        PlanLevelValidator.validateUniqueJNDIName(spec);
        PlanLevelValidator.validateUniformDistributedQueues(spec);
        PlanLevelValidator.validateQueueIsTargetedToSingleJmsServer(spec);
        return null;
    }

    private static void validateArtifactDeploymentOptions(DeltaSpecification spec) {
        Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> deployeds = PlanLevelValidator.getAllDeployedArtifacts(spec);
        for (Deployable eachArtifact : deployeds.keySet()) {
            Collection artifactDeployeds = deployeds.get((Object)eachArtifact);
            PlanLevelValidator.validateDeploymentOptionsAreSame(artifactDeployeds);
        }
    }

    private static Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> getAllDeployedArtifacts(DeltaSpecification spec) {
        HashMultimap deployeds = HashMultimap.create();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !ExtensibleDeployedArtifact.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            ExtensibleDeployedArtifact artifact = (ExtensibleDeployedArtifact)each.getDeployed();
            deployeds.put((Object)artifact.getDeployable(), (Object)artifact);
        }
        return deployeds;
    }

    private static void validateDeploymentOptionsAreSame(Collection<ExtensibleDeployedArtifact<DeployableArtifact>> artifactDeployeds) {
        Iterator<ExtensibleDeployedArtifact<DeployableArtifact>> iterator = artifactDeployeds.iterator();
        if (iterator.hasNext()) {
            ExtensibleDeployedArtifact<DeployableArtifact> reference = iterator.next();
            while (iterator.hasNext()) {
                ExtensibleDeployedArtifact<DeployableArtifact> next = iterator.next();
                PlanLevelValidator.validateSameValues(reference, next);
            }
        }
    }

    private static void validateSameValues(ExtensibleDeployedArtifact<DeployableArtifact> reference, ExtensibleDeployedArtifact<DeployableArtifact> deployed) {
        if (((WlsContainer)reference.getContainer()).getDomain().equals((Object)((WlsContainer)deployed.getContainer()).getDomain())) {
            if (reference.isVersioned() != deployed.isVersioned()) {
                throw new RuntimeException("Can't have different values for 'versioned' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getStageMode() != deployed.getStageMode()) {
                throw new RuntimeException("Can't have different values for 'stageMode' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getStagingDirectory() != null && !reference.getStagingDirectory().equals(deployed.getStagingDirectory())) {
                throw new RuntimeException("Can't have different values for 'stagingDirectory' property for same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
            if (reference.getRedeploymentStrategy() != deployed.getRedeploymentStrategy()) {
                throw new RuntimeException("Can't have different values for the deployment strategy for the same artifact " + ((DeployableArtifact)reference.getDeployable()).getName());
            }
        }
    }

    private static void validateUniqueJNDIName(DeltaSpecification spec) {
        HashMap<String, String> jndiNames = new HashMap<String, String>();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !JmsResource.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            JmsResource jmsResource = (JmsResource)each.getDeployed();
            if (jndiNames.get(jmsResource.getJndiName()) != null && !((String)jndiNames.get(jmsResource.getJndiName())).equals(((JmsResourceSpec)jmsResource.getDeployable()).getName())) {
                throw new RuntimeException(String.format("Jndi name %s is in use by multiple resource sources", jmsResource.getJndiName()));
            }
            jndiNames.put(jmsResource.getJndiName(), ((JmsResourceSpec)jmsResource.getDeployable()).getName());
        }
    }

    private static void validateUniformDistributedQueues(DeltaSpecification spec) {
        HashMap<String, Cluster> uddQueueContainers = new HashMap<String, Cluster>();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !AbstractUniformDistributedQueue.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            AbstractUniformDistributedQueue jmsResource = (AbstractUniformDistributedQueue)each.getDeployed();
            Cluster cluster = PlanLevelValidator.getContainerCluster(jmsResource);
            if (uddQueueContainers.containsKey(jmsResource.getName()) && !((Cluster)uddQueueContainers.get(jmsResource.getName())).equals(cluster)) {
                throw new RuntimeException(String.format("The UDD %s must be targeted to servers within a single cluster or a single stand-alone server", jmsResource.getName()));
            }
            uddQueueContainers.put(jmsResource.getName(), cluster);
        }
    }

    private static void validateQueueIsTargetedToSingleJmsServer(DeltaSpecification spec) {
        HashMap<String, Container> queueJmsServers = new HashMap<String, Container>();
        for (Delta each : spec.getDeltas()) {
            if (each.getOperation() != Operation.CREATE && each.getOperation() != Operation.MODIFY || !AbstractQueue.class.isAssignableFrom(each.getDeployed().getClass())) continue;
            AbstractQueue queue = (AbstractQueue)each.getDeployed();
            if (queueJmsServers.containsKey(queue.getName()) && !((JmsServer)queue.getContainer()).equals(queueJmsServers.get(queue.getName()))) {
                throw new RuntimeException(String.format("Queue %s must be targeted to only a single JmsServer", queue.getName()));
            }
            queueJmsServers.put(queue.getName(), queue.getContainer());
        }
    }

    private static Cluster getContainerCluster(AbstractUniformDistributedQueue jmsResource) {
        JmsTarget container = (JmsTarget)jmsResource.getContainer();
        Cluster cluster = null;
        if (Cluster.class.isAssignableFrom(container.getClass())) {
            cluster = (Cluster)container;
        } else if (JmsServer.class.isAssignableFrom(container.getClass())) {
            cluster = ((JmsServer)container).getServer().getClusterIfAny();
        }
        return cluster;
    }
}

