/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WlsArtifactProcessor {
    private static final Function<Delta, ExtensibleDeployedArtifact<?>> TO_DEPLOYED = new Function<Delta, ExtensibleDeployedArtifact<?>>(){

        public ExtensibleDeployedArtifact<?> apply(Delta delta) {
            Deployed deployed = delta.getDeployed();
            return deployed instanceof ExtensibleDeployedArtifact ? (ExtensibleDeployedArtifact)deployed : null;
        }
    };
    private static final Predicate<ExtensibleDeployedArtifact<?>> IS_VERSIONED = new Predicate<ExtensibleDeployedArtifact<?>>(){

        public boolean apply(ExtensibleDeployedArtifact<?> input) {
            return Predicates.notNull().apply(input) && (input.isVersioned() || this.isSharedLibrary(input));
        }

        private boolean isSharedLibrary(ExtensibleDeployedArtifact<?> input) {
            Type inputType = input.getType();
            return inputType.equals((Object)ExtensibleDeployedArtifact.DEPLOYED_SHARED_LIB_WAR);
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(WlsArtifactProcessor.class);

    @PrePlanProcessor
    public Step setVersionIdentifiers(DeltaSpecification spec) {
        String appVersion = spec.getDeployedApplication().getVersion().getVersion();
        String appName = spec.getDeployedApplication().getVersion().getApplication().getName();
        String defaultVersion = appName + "-" + appVersion;
        VersionSetter version = new VersionSetter(defaultVersion);
        for (ExtensibleDeployedArtifact artifact : Iterables.filter((Iterable)Iterables.transform((Iterable)spec.getDeltas(), TO_DEPLOYED), IS_VERSIONED)) {
            if (!Strings.isNullOrEmpty((String)artifact.getVersionIdentifier())) continue;
            version.apply(artifact);
        }
        return null;
    }

    private class VersionSetter
    implements Function<ExtensibleDeployedArtifact<?>, Void> {
        private final String defaultVersion;

        public VersionSetter(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public Void apply(ExtensibleDeployedArtifact<?> deployed) {
            Artifact artifact = (Artifact)deployed.getDeployable();
            File manifestFile = ((LocalFile)artifact.getFile()).getFile();
            Manifest manifest = this.readManifest(manifestFile);
            if (manifest == null) {
                logger.debug("Unable to read manifest for {}", (Object)manifestFile);
                return null;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String extName = mainAttributes.getValue("Extension-Name");
            deployed.setVersioned(true);
            if (Strings.isNullOrEmpty((String)extName)) {
                logger.debug("Setting version identifier to default value '{}'", (Object)this.defaultVersion);
                deployed.setVersionIdentifier(this.defaultVersion);
            } else {
                String specVersion = mainAttributes.getValue("Specification-Version");
                String implVersion = mainAttributes.getValue("Implementation-Version");
                String versionIdentifier = Strings.isNullOrEmpty((String)implVersion) ? specVersion : specVersion + "@" + implVersion;
                logger.debug("Setting version identifier to manifest-derived value '{}'", (Object)versionIdentifier);
                deployed.setVersionIdentifier(versionIdentifier);
            }
            return null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Manifest readManifest(File archiveFile) {
            Manifest manifest;
            TFile tFile = new TFile(archiveFile, "META-INF/MANIFEST.MF");
            TFileInputStream is = null;
            try {
                Preconditions.checkArgument((boolean)tFile.exists(), (String)"The archive [%s] does not contain a MANIFEST.MF file.", (Object[])new Object[]{archiveFile});
                is = new TFileInputStream((File)tFile);
                manifest = new Manifest((InputStream)is);
            }
            catch (FileNotFoundException fnfe) {
                try {
                    throw new RuntimeIOException(String.format("The archive [%s] does not contain a MANIFEST.MF file.", archiveFile), (Throwable)fnfe);
                    catch (IOException e) {
                        throw new RuntimeIOException(String.format("Error reading the MANIFEST.MF in archive [%s].", archiveFile), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    try {
                        TFile.umount((TFile)tFile);
                        throw throwable;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)is);
            try {
                TFile.umount((TFile)tFile);
                return manifest;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return manifest;
        }
    }
}

