<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
echo "Starting ${container.name}...."
RESPONSE_FILE=${container.name}.$$
<#if container.name = container.domain.adminServerName>
echo "start AdminServer..."
nohup ${container.domain.domainHome}/bin/${container.startCommand}.sh >> $RESPONSE_FILE 2>&1 &
<#else>
echo "start ManagedServer..."
nohup ${container.domain.domainHome}/bin/${container.startCommand}.sh ${container.name}  >> $RESPONSE_FILE 2>&1 &
</#if>


<#if container.testServerIsRunning >
START_DELAY_SECS=${container.startDelay}

if [ $START_DELAY_SECS -ne 0 ]; then
  echo Waiting $START_DELAY_SECS seconds
  sleep $START_DELAY_SECS
fi

cat $RESPONSE_FILE

MAX_RETRIES=${container.maxRetries}
RETRY_INTERVAL_SECS=${container.retryWaitInterval}

source ${container.domain.domainHome}/bin/setDomainEnv.sh

for (( i=1; i<=$MAX_RETRIES; i++ )); do

  echo Executing "$JAVA_HOME/bin/java weblogic.Admin -url t3://${container.host.address}:${container.port} -username ${container.domain.username} -password ******** ping 1 1"
  $JAVA_HOME/bin/java weblogic.Admin -url t3://${container.host.address}:${container.port} -username ${container.domain.username} -password ${container.domain.password} ping 1 1

  PING_EXIT_CODE=$?
  if [ $PING_EXIT_CODE -eq 0 ]; then
    echo "exit code is $PING_EXIT_CODE	"
    echo "----- SERVER STATUS -----"
    $JAVA_HOME/bin/java weblogic.Admin -url t3://${container.host.address}:${container.port} -username ${container.domain.username} -password ${container.domain.password} GETSTATE ${container.name}
    echo "----- SERVER STATUS -----"
    exit 0
    break
  fi

  echo "retry in ${container.retryWaitInterval} seconds"
  sleep $RETRY_INTERVAL_SECS
done

if [ $PING_EXIT_CODE -ne 0 ]; then
  echo ERROR: '${container.name}' is not started !
  exit $PING_EXIT_CODE
fi

echo "${container.name} is started."
exit 0

</#if>